<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    
    session_start();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    $nome        = filter_input(INPUT_POST,'nome',FILTER_SANITIZE_ADD_SLASHES);
    $cognome     = filter_input(INPUT_POST,'cognome',FILTER_SANITIZE_ADD_SLASHES);
    $email       = filter_input(INPUT_POST,'email',FILTER_SANITIZE_EMAIL);
    $password    = hash("sha512",filter_input(INPUT_POST,'password'));
    $urlSito     = filter_input(INPUT_POST,'urlSito',FILTER_SANITIZE_URL);
    $titoloSito  = filter_input(INPUT_POST,'titoloSito',FILTER_SANITIZE_ADD_SLASHES);
    $cartellaAmministrazione = filter_input(INPUT_POST,'cartellaAmministrazione',FILTER_SANITIZE_ADD_SLASHES);
    $linkAreaRiservata       = "$urlSito/$cartellaAmministrazione";
    
    // array contenente tutte le query per creare le tabelle, che poi verranno passate al dbManager che le eseguirà in blocco
    $queryCreazioniTabelle = array();
    $queryTabelleComuni    = array();
    $queryDiConfigurazione = array();
    
    //query per creare la tabella dei componenti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_componenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `componenteArticolo` VARCHAR( 255 ) NOT NULL ,
        `icona` VARCHAR( 255 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `paginaGestione` VARCHAR( 255 ) NOT NULL,
        `tabellaRiferimento` VARCHAR( 255 ) NOT NULL,
        `script` VARCHAR( 255 ) NOT NULL,
        `versione` VARCHAR( 255 ) NOT NULL,
        `cruscottoHome` VARCHAR( 255 ) DEFAULT 'no',
        `tabellaRiassuntivaHome` VARCHAR( 255 ) DEFAULT 'no',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella del pannello laterale di destra, che consente di capire quali componenti 
    //mostrare a lato e in che ordine
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_composizionePannelloLaterale` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `idComponente` INT( 11 ) NOT NULL ,
        `idElemento` INT( 11 ) NOT NULL ,
        `nomePannello` VARCHAR( 255 ) NOT NULL ,
        `posizione` TINYINT( 4 ) NOT NULL ,
        `nomeDaMostrare` VARCHAR( 255 ) NOT NULL ,
        `testo` TEXT( 65000 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella della colonna laterale di sinistra che consente di capire quali componenti 
    //mostrare a lato e in che ordine
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_composizionePagine` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `idComponente` INT( 11 ) NOT NULL ,
        `idPagina` INT( 11 ) NOT NULL ,
        `tipoElemento` VARCHAR( 255 ) NOT NULL ,
        `idElemento` INT( 11 ) NOT NULL ,
        `posizione` TINYINT( 11 ) NOT NULL ,
        `testo` TEXT( 65000 ) ,
        `codiceGenerato` TEXT( 65000 ) ,
        `script` TEXT( 65000 ) ,
        `nascosto` VARCHAR( 255 ) DEFAULT 'no' ,
        `idSezione` VARCHAR( 255 ) DEFAULT '' ,
        `classeSezione` VARCHAR( 255 ) DEFAULT '' ,
        `aTuttaLarghezza` VARCHAR( 55 ) DEFAULT '' ,
        `margineSezione` VARCHAR( 255 ) DEFAULT '' ,
        `paddingSezione` VARCHAR( 255 ) DEFAULT '' ,
        `animazione` VARCHAR( 255 ) DEFAULT '' ,
        `coloreSfondo` VARCHAR( 255 ) DEFAULT '' ,
        `immagineSfondo` VARCHAR( 255 ) DEFAULT '' ,
        `videoSfondo` VARCHAR( 255 ) DEFAULT '' ,
        `altreOpzioni` TEXT( 65000 ),
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    // query per creare la tabella contenuti, che contiene pagine, gallerie e articoli ed
    // elementi portfolio. Gallerie ed elementi portfolio lasceranno alcuni campi vuoti
    // 
    // il campo posizione ad esempio è utilizzato solo per gli elementi del portfolio
    // cosi come il campo tipoVisualizzazione è usato solo dalla galleria
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_contenuti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `contenutoRiferimento` INT( 11 ) NOT NULL,
        `linguaContenuto` VARCHAR( 55 ) NOT NULL ,
        `tipo` VARCHAR( 55 ) NOT NULL ,
        `posizione` INT(11) NOT NULL,
        `categoria` INT(11) NOT NULL,
        `mostraNellaHome` VARCHAR( 255 ) NOT NULL ,
        `stato` VARCHAR( 255 ) NOT NULL ,
        `punteggioSeo` VARCHAR( 255 ) NOT NULL ,
        `template` VARCHAR( 255 ) NOT NULL ,
        `attivaBreadcrumbs` VARCHAR( 55 ) NOT NULL ,
        `tipoVisualizzazione` VARCHAR( 55 ) NOT NULL ,
        `titolo` VARCHAR( 255 ) NOT NULL ,
        `metaTitolo` VARCHAR( 255 ) NOT NULL ,        
        `mostraTitolo` VARCHAR( 255 ) NOT NULL ,
        `metaDescrizione` VARCHAR( 255 ) NOT NULL ,
        `descrizione` VARCHAR( 255 ) NOT NULL ,
        `alias` VARCHAR( 255 ) NOT NULL ,
        `cssGenerato` TEXT( 65000 ) NOT NULL ,
        `cssAggiuntivo` TEXT( 65000 ) NOT NULL ,
        `testo` TEXT( 65000 ) NOT NULL ,
        `abilitaCommenti` VARCHAR( 255 ) NOT NULL ,
        `numeroVisite` INT( 11 ) NOT NULL ,
        `foto` VARCHAR( 255 ) NOT NULL ,
        `miniaturaFoto` VARCHAR( 255 ) NOT NULL ,
        `etichettaImmagine` VARCHAR(255) NOT NULL, 
        `autore` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL ,
        `dataUltimaVisita` DATE NOT NULL ,
        `dataUltimaModifica` DATE NOT NULL ,
        `dataPubblicazione` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella commenti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_commenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idContenuto` INT( 11 ) NOT NULL,
        `inRispostaA` INT( 11 ) NOT NULL,
        `email` VARCHAR( 255 ) NOT NULL ,
        `nomeAutore` VARCHAR( 255 ) NOT NULL ,
        `testo` TEXT( 1000 ) NOT NULL ,
        `segnalato` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella tag
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_tag` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `posizione` INT( 11 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella che associa i tag e gli articoli
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_associazioniTagArticoli` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idArticolo` INT( 11 ) NOT NULL ,
        `idTag` INT( 11 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    /*
     * query per creare la tabella delle immagini
     * il campo tipoImmagine 
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_immagini` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idContenuto` INT( 11 ) NOT NULL,
        `tipoImmagine` VARCHAR( 255 ) NOT NULL ,
        `percorso` VARCHAR( 255 ) NOT NULL ,
        `descrizione` VARCHAR( 255 ) NOT NULL ,
        `posizione` TINYINT NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    /*
     *  query per creare la tabella delle voci di menu
     * 
     * il campo voceMenuCollegata si riferisce a eventuali mega menu
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_menu` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `voceMenuCollegata` INT( 11 ) NOT NULL ,
        `posizioneNellaVoceMenu` TINYINT( 4 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `formRicerca` VARCHAR( 55 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella delle voci di menu
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_vociMenu` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idMenu` INT( 11 ) NOT NULL,
        `idContenuto` INT( 11 ) NOT NULL,
        `vocePadre` INT( 11 ) NOT NULL,
        `mostraNomiColonne` VARCHAR( 55 ) NOT NULL ,
        `testoAssociato` VARCHAR( 255 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `icona` VARCHAR( 255 ) NOT NULL ,
        `immagine` VARCHAR( 255 ) NOT NULL ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `link` VARCHAR( 255 ) NOT NULL,
        `posizione` INT( 11 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella delle impostazioni di aspetto, che consentono di scegliere come sarà il menu
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_impostazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `aspettoSito` VARCHAR (55) NOT NULL,
        `azzeraMargineSuperiore` VARCHAR (55) NOT NULL,
        `reindirizzamentoHttps` VARCHAR (55) NOT NULL,
        `inviaMailLogin` VARCHAR (55) NOT NULL,
        `loginADueFasi` VARCHAR (55) NOT NULL,
        `ottimizzazioneUrl` VARCHAR (55) NOT NULL,
        `consentiIndicizzazione` VARCHAR (55) NOT NULL,
        `generazioneMappa` VARCHAR (55) NOT NULL,
        `generaMappeSeparatePerLingua` VARCHAR (55) NOT NULL,
        `attivaCache` VARCHAR (55) NOT NULL,
        `categoriaInEvidenza` INT( 11 ) NOT NULL ,
        `aspettoCategoriaInEvidenza` VARCHAR( 255 ) NOT NULL ,
        `menuSecondario` VARCHAR (55) NOT NULL,
        `idMenuSecondario` INT( 11 ) NOT NULL,
        `allineamentoMenuSecondario` VARCHAR (55) NOT NULL,
        `mostraTestoBarraSuperiore` VARCHAR (55) NOT NULL,
        `testoBarraSuperiore` VARCHAR (255) NOT NULL,
        `allineamentoTestoBarraSuperiore` VARCHAR (55) NOT NULL,
        `mostraProfiliSocial` VARCHAR (55) NOT NULL,
        `attivaBarraSuperiore` VARCHAR (55) NOT NULL,
        `coloreBarraSuperiore` VARCHAR (55) NOT NULL,
        `coloreTestoBarraSuperiore` VARCHAR (55) NOT NULL,
        `menuSceltaLingue` VARCHAR (55) NOT NULL,
        `attivaFortino` VARCHAR (55) NOT NULL,
        `parolaChiaveFortino` VARCHAR (55) NOT NULL,
        `bloccaLinkCommenti` VARCHAR (55) NOT NULL,
        `disattivaTastoDestroMouse` VARCHAR (55) NOT NULL,
        `homePage` INT( 11 ) NOT NULL,
        `homePageEn` INT( 11 ) NOT NULL,
        `homePageDe` INT( 11 ) NOT NULL,
        `homePageFr` INT( 11 ) NOT NULL,
        `homePageEs` INT( 11 ) NOT NULL,
        `urlSito` VARCHAR( 255 ) NOT NULL ,
        `titoloSito` VARCHAR( 255 ) NOT NULL ,
        `titoloEsteso` VARCHAR( 255 ) NOT NULL ,
        `descrizioneSito` VARCHAR( 255 ) NOT NULL ,
        `linguaSito` VARCHAR( 255 ) NOT NULL ,
        `manutenzione` VARCHAR( 255 ) NOT NULL ,
        `paginaManutenzione` VARCHAR( 255 ) NOT NULL ,
        `mostraGuidaIniziale` VARCHAR( 255 ) NOT NULL ,
        `filtraggioIP` VARCHAR( 55 ) NOT NULL ,
        `indirizziIPAmmessi` TEXT( 65000 ) NOT NULL ,
        `indirizziIPBannati` TEXT( 65000 ) NOT NULL ,
        `filtraggioIPCommenti` VARCHAR( 55 ) NOT NULL ,
        `indirizziIPAmmessiCommenti` TEXT( 65000 ) NOT NULL ,
        `indirizziIPBannatiCommenti` TEXT( 65000 ) NOT NULL ,
        `ottimizzaImmaginiCaricate` VARCHAR( 55 ) NOT NULL ,
        `altezzaImmagine` SMALLINT( 6 ) NOT NULL ,
        `generaThumbnail` VARCHAR( 55 ) NOT NULL ,
        `altezzaThumbnail` SMALLINT( 6 ) NOT NULL ,
        `comprimiCss` VARCHAR( 55 ) NOT NULL ,
        `comprimiJs` VARCHAR( 55 ) NOT NULL ,
        `classeElementiStatisticiPerRigaHomeAdmin` VARCHAR( 55 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella delle impostazioni delle lingue
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_impostazioniLingue` (
            `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
            `linguaPrincipale` VARCHAR(255) NOT NULL ,
            `impostazioniItaliano` VARCHAR(55) NOT NULL ,
            `menuItaliano` INT(11) NOT NULL ,
            `menuSecondarioItaliano` INT(11) NOT NULL ,
            `paginaBlogItaliano` INT(11) NOT NULL ,
            `impostazioniInglese` VARCHAR(55) NOT NULL ,
            `menuInglese` INT(11) NOT NULL ,
            `menuSecondarioInglese` INT(11) NOT NULL ,
            `paginaBlogInglese` INT(11) NOT NULL ,
            `impostazioniTedesco` VARCHAR(55) NOT NULL ,
            `menuTedesco` INT(11) NOT NULL ,
            `menuSecondarioTedesco` INT(11) NOT NULL ,
            `paginaBlogTedesco` INT(11) NOT NULL ,
            `impostazioniFrancese` VARCHAR(55) NOT NULL ,
            `menuFrancese` INT(11) NOT NULL ,
            `menuSecondarioFrancese` VARCHAR(55) NOT NULL ,
            `paginaBlogFrancese` INT(11) NOT NULL ,
            `impostazioniSpagnolo` VARCHAR(55) NOT NULL ,
            `menuSpagnolo` INT(11) NOT NULL ,
            `menuSecondarioSpagnolo` INT(11) NOT NULL ,
            `paginaBlogSpagnolo` INT(11) NOT NULL ,
            PRIMARY KEY ( `id` )
            ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella delle impostazioni della ricerca
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_impostazioniRicerca` (
            `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
            `elementiPerPagina` INT( 11 ) NOT NULL ,
            `rimuoviUltimaLettera` VARCHAR(55) NOT NULL ,
            `salvaRicercheUtenti` VARCHAR( 55 ) NOT NULL ,
            `cercaContenutiPerTitolo` VARCHAR( 55 ) NOT NULL ,
            `cercaContenutiPerMetaDescrizione` VARCHAR( 55 ) NOT NULL ,
            `cercaContenutiPerSottotitolo` VARCHAR( 55 ) NOT NULL ,
            `cercaContenutiPerTesto` VARCHAR( 55 ) NOT NULL ,
            `cercaProdottiPerNome` VARCHAR( 55 ) NOT NULL ,
            `cercaProdottiPerMetaDescrizione` VARCHAR( 55 ) NOT NULL ,
            `cercaProdottiPerTesto` VARCHAR( 55 ) NOT NULL ,
            `cercaProdottiPerTestoDettagli` VARCHAR( 55 ) NOT NULL ,
            `cercaProdottiPerMarca` VARCHAR( 55 ) NOT NULL ,
            `cercaProdottiPerModello` VARCHAR( 55 ) NOT NULL ,
            PRIMARY KEY ( `id` )
            ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella del componente integrato immagine a lato
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_banner` (
            `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
            `nome` VARCHAR( 255 ) NOT NULL ,
            `spazioOccupato` VARCHAR(55) DEFAULT 'col-12',
            `animazione` VARCHAR( 255 ) DEFAULT '',
            `colore` VARCHAR( 255 ) DEFAULT '',
            `dataCreazione` DATETIME DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY ( `id` )
            ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella del componente integrato immagine a lato
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_campagneBanner` (
            `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
            `idBanner` INT( 11 ) NOT NULL,
            `attiva` VARCHAR( 55 ) DEFAULT '',
            `nome` VARCHAR( 255 ) DEFAULT '',
            `link` VARCHAR( 255 ) DEFAULT '',
            `immagine` VARCHAR( 255 ) DEFAULT '',
            `immagineMobile` VARCHAR( 255 ) DEFAULT '',
            `spazioOccupato` VARCHAR( 255 ) DEFAULT '',
            `numeroClickOggi` INT (11) DEFAULT 0,
            `numeroClickTotali` INT (11) DEFAULT 0,
            `numeroClickOggiMobile` INT (11) DEFAULT 0,
            `numeroClickTotaliMobile` INT (11) DEFAULT 0,
            `dataCreazione` DATETIME DEFAULT CURRENT_TIMESTAMP,
            `dataUltimoClick` DATETIME DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY ( `id` )
            ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella del componente integrato menu laterale
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_menuLaterale` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `mostraPannelloLaterale` VARCHAR( 255 ) NOT NULL,
        `idMenu` INT( 11 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare gli slider
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_slider` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `tipoTransizione` VARCHAR( 55 ) DEFAULT 'none',
        `spazioOccupato` VARCHAR( 55 ) DEFAULT 'col-12',
        `altezza` VARCHAR( 55 ) DEFAULT 'h50',
        `mostraFreccette` VARCHAR( 55 ) DEFAULT '',
        `mostraPuntiNavigazione` VARCHAR( 55 ) DEFAULT '',
        `autoplay` VARCHAR( 55 ) DEFAULT '',
        `pausaOnHover` VARCHAR( 55 ) DEFAULT '',
        `tempoPermanenzaSingolaSlide` INT( 11 ) DEFAULT '4000',
        `slideMostrateSuLargeDesktop` SMALLINT( 4 ) DEFAULT 1,
        `slideMostrateSuDesktop` SMALLINT( 4 ) DEFAULT 1,
        `slideMostrateSuTablet` SMALLINT( 4 ) DEFAULT 1,
        `slideMostrateSuSmartphone` SMALLINT( 4 ) DEFAULT 1,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella del componente integrato slider
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_slide` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idSlider` INT( 11 ) NOT NULL,
        `posizione` SMALLINT( 6 ) NOT NULL,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `testo` TEXT( 1000 ) NOT NULL ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `percorsoFileMultimediale` VARCHAR( 255 ) NOT NULL ,
        `link` VARCHAR( 255 ) NOT NULL,
        `overlay` VARCHAR( 255 ) NOT NULL ,
        `gradiente` VARCHAR( 255 ) NOT NULL ,
        `linkPulsante` VARCHAR(255) NOT NULL,
        `stilePulsante` VARCHAR(255) NOT NULL,
        `titoloPulsante` VARCHAR(255) NOT NULL,
        `numeroClick` INT( 11 ) NOT NULL,
        `dataCreazione` DATETIME NOT NULL,
        `dataUltimoClick` DATETIME NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella della vetrina degli elementi
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_metroSlider` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL,
        `spazioOccupato` VARCHAR(55) DEFAULT 'col-12',
        `articoliPerSlide` INT( 11 ) NOT NULL DEFAULT 3,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella degli elementi delle vetrine
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_slideMetro` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idSlider` INT( 11 ) NOT NULL,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `linguaContenuti` VARCHAR( 55 ) NOT NULL ,
        `contenuti` VARCHAR( 255 ) NOT NULL,
        `posizione` SMALLINT( 6 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella del componente integrato colonne in evidenza
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_colonneInEvidenza` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR (255) NOT NULL ,
        `spazioOccupato` VARCHAR (255) DEFAULT 'col-12',
        `classeColonne` VARCHAR (255) DEFAULT '',
        `primaColonna` INT (11) DEFAULT 0,
        `secondaColonna` INT (11) DEFAULT 0,
        `terzaColonna` INT (11) DEFAULT 0,
        `quartaColonna` INT (11) DEFAULT 0,
        `testoPrimaColonna` VARCHAR (255) DEFAULT '',
        `testoSecondaColonna` VARCHAR (255) DEFAULT '',
        `testoTerzaColonna` VARCHAR (255) DEFAULT '',
        `testoQuartaColonna` VARCHAR (255) DEFAULT '',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella del componente integrato popup
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_popup` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `link` VARCHAR( 255 ) NOT NULL ,
        `immagine` VARCHAR( 255 ) NOT NULL ,
        `testo` TEXT( 1000 ) NOT NULL,
        `categoria` INT ( 11) NOT NULL ,
        `singoloContenuto` INT ( 11) NOT NULL ,
        `secondi` TINYINT ( 11) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella del componente integrato articoliDalBlog
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_articoliDalBlog` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL,
        `spazioOccupato` VARCHAR( 255 ) NOT NULL DEFAULT 'col-12',
        `numeroArticoli` INT(11) NOT NULL DEFAULT 1,
        `dimensioneDivSingoloArticolo` VARCHAR( 255 ) NOT NULL DEFAULT 'col-lg-8 mx-auto',
        `categoria` INT(11) NOT NULL DEFAULT 0,
        `categorieIndicate` VARCHAR( 255 ) NOT NULL DEFAULT '',
        `escludiCategoria` INT(11) NOT NULL DEFAULT -1,
        `lingua` VARCHAR(255) NOT NULL DEFAULT'',
        `etichettaPulsanteALtriArticoli` VARCHAR(255) NOT NULL DEFAULT '',
        `mostraTitoloComponente` VARCHAR(255) NOT NULL DEFAULT '',
        `mostraImmagini` VARCHAR(255) NOT NULL DEFAULT '',
        `mostraTesto` VARCHAR(255) NOT NULL DEFAULT '',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella contenente i vari portfolii
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_portfolio` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `spazioOccupato` VARCHAR( 255 ) DEFAULT 'col-12',
        `descrizione` VARCHAR( 255 ) DEFAULT '',
        `etichettaAltriElementi` VARCHAR( 255 ) DEFAULT '',
        `linkPagina` VARCHAR( 255 ) DEFAULT '',
        `filtrabile` VARCHAR( 255 ) DEFAULT 'no',
        `senzaBordi` VARCHAR( 255 ) DEFAULT 'no',
        `classeElementi` VARCHAR( 255 ) DEFAULT 'portfolio col-sm-6 col-md-4',
        `mostraNomiElementi` VARCHAR( 255 ) DEFAULT 'no',
        `aspetto` VARCHAR( 255 ) DEFAULT 'classico',
        `aspectRatio` VARCHAR( 255 ) DEFAULT 'aspect-ratio-1-1',
        `mostraImmagineInEvidenza` VARCHAR( 255 ) DEFAULT 'no',
        `traduzioneItaliano` INT( 11 ) DEFAULT 0,
        `traduzioneInglese` INT( 11 ) DEFAULT -1,
        `traduzioneTedesco` INT( 11 ) DEFAULT -1,
        `traduzioneFrancese` INT( 11 ) DEFAULT -1,
        `traduzioneSpagnolo` INT( 11 ) DEFAULT -1,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella contenente le liste
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_liste` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `descrizione` VARCHAR( 255 ) DEFAULT '',
        `spazioOccupato` VARCHAR( 255 ) DEFAULT 'col-12' ,
        `icona` VARCHAR( 255 ) DEFAULT '',
        `tipoVisualizzazione` VARCHAR( 255 ) DEFAULT 'sequenza, una colonna',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare gli elementi delle liste
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_elementiLista` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `idLista` int(11) NOT NULL,
        `classeElemento` varchar(255) NOT NULL,
        `nome` varchar(255) NOT NULL,
        `descrizione` TEXT(65000) NOT NULL,
        `posizione` smallint(6) NOT NULL,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
   
    //query per creare la tabella contenente le sezioni dei prezzi
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_tabelle` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `spazioOccupato` VARCHAR( 255 ) DEFAULT 'col-12' ,
        `ordinabile` VARCHAR( 255 ) DEFAULT '' ,
        `intestazione` VARCHAR( 255 ) DEFAULT '' ,
        `sfondoIntestazione` VARCHAR( 255 ) DEFAULT '' ,
        `coloreTestiIntestazione` VARCHAR( 255 ) DEFAULT '' ,
        `note` VARCHAR( 255 ) DEFAULT '' ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella contenente le sezioni dei prezzi
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_righeTabella` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idTabella` INT( 11 ) NOT NULL ,
        `posizione` SMALLINT( 6 ) NOT NULL ,
        `elementi` VARCHAR( 255 ) NOT NULL ,
        `coloreSfondo` VARCHAR( 255 ) NOT NULL ,
        `coloreTesti` VARCHAR( 255 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
        
    //query per creare la tabella contenente le sezioni dei prezzi
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_tabellePrezzi` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `spazioOccupato` VARCHAR( 255 ) DEFAULT 'col-12' ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella contenente le tabelle dei prezzi
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_colonneTabellaPrezzi` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idTabella` INT( 11 ) NOT NULL ,
        `posizione` smallint(6) NOT NULL,        
        `nome` VARCHAR( 255 ) NOT NULL ,
        `descrizione` VARCHAR( 255 ) NOT NULL ,
        `immagine` VARCHAR( 255 ) NOT NULL ,
        `prezzo` VARCHAR( 55 ) NOT NULL ,
        `prezzoScontato` VARCHAR( 55 ) NOT NULL ,
        `valuta` VARCHAR( 55 ) NOT NULL ,
        `suffisso` VARCHAR( 55 ) NOT NULL ,
        `link` VARCHAR( 255 ) NOT NULL ,
        `etichettaLink` VARCHAR( 255 ) NOT NULL ,
        `numeroClick` INT (11) NOT NULL,
        `dataUltimoClick` DATETIME NOT NULL,
        `preferita` VARCHAR( 255 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare gli elementi della tabella prezzi
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_elementiTabellaPrezzi` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `idColonna` int(11) NOT NULL,
        `posizione` smallint(6) NOT NULL,
        `nome` varchar(255) NOT NULL,
        `icona` varchar(255) NOT NULL,
        `classeElemento` TEXT(65000) NOT NULL,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella contenente le sezioni sdoppiate
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_sezioniSdoppiate` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `spazioOccupato` VARCHAR(255) DEFAULT 'col-12',
        `proporzioni` VARCHAR( 255 ) DEFAULT '',
        `altezza` VARCHAR(255) DEFAULT 'h50',
        `usaParallax` VARCHAR(255) DEFAULT 'no',
        `doveSiTrovaImmagine` VARCHAR( 255 ) DEFAULT '',
        `doveSiTrovaImmagineSuMobile` VARCHAR( 255 ) DEFAULT '',
        `stileImmagine` VARCHAR( 255 ) DEFAULT 'Immagine di sfondo',
        `animazioneImmagine` VARCHAR( 255 ) DEFAULT '',
        `testo` TEXT(65000),
        `classeDivImmagine` varchar(255) DEFAULT '',
        `classeDivTesto` varchar(255) DEFAULT '',
        `animazioneTesto` varchar(255) DEFAULT '',
        `coloreDivTesto` varchar(255) DEFAULT '',
        `immagine` VARCHAR( 255 ) DEFAULT '',
        `tagAltImmagine` VARCHAR( 255 ) DEFAULT '',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella del componente
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_invitiAzione` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR(255) NOT NULL,
        `spazioOccupato` VARCHAR(255) DEFAULT 'col-12',
        `percorsoImmagine` varchar(255) DEFAULT '',
        `altezza` VARCHAR(255) DEFAULT 'h20',
        `testo` TEXT(65000),
        `linkPulsante` VARCHAR(255) DEFAULT '',
        `stilePulsante` VARCHAR(255) DEFAULT '',
        `titoloPulsante` VARCHAR(255) DEFAULT '',
        `numeroClick` INT (11) DEFAULT 0,
        `dataCreazione` DATETIME DEFAULT CURRENT_TIMESTAMP,
        `dataUltimoClick` DATETIME DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella del componente integrato colonne in evidenza
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_blog` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `articoliPerPagina` INT( 11 ) NOT NULL ,
        `idArticoloInEvidenza` INT( 11 ) NOT NULL ,
        `articoloInEvidenza` VARCHAR( 255 ) NOT NULL ,
        `articoliSuccessivi` VARCHAR( 255 ) NOT NULL ,
        `aspettoImmagineInEvidenzaArticolo` VARCHAR( 255 ) NOT NULL ,
        `aspettoImmaginePaginaArticolo` VARCHAR( 255 ) NOT NULL ,
        `mostraPaginazione` VARCHAR( 255 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_statistiche` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `visiteGiornaliere` INT( 11 ) NOT NULL ,
        `dataCorrente` DATE NOT NULL ,
        `dataInstallazione` DATE NOT NULL ,
        `ultimoAggiornamentoSitemap` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
 
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_ricercheEffettuate` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `parolaChiave` VARCHAR( 255 ) NOT NULL ,
        `numeroRicerche` INT( 11 ) NOT NULL ,
        `primaRicerca` DATE NOT NULL ,
        `ultimaRicerca` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * Query per creare la tabella che raccoglie le visualizzazioni giornaliere del sito
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_visualizzazioniGiornaliere` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `visualizzazioni` INT( 11 ) NOT NULL ,
        `data` DATE NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_inclusioni` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `inizioHead` TEXT(65000) NOT NULL,
      `fineHead` TEXT(65000) NOT NULL,
      `inizioBody` TEXT(65000) NOT NULL,
      `fineBody` TEXT(65000) NOT NULL,
      `footer` TEXT(65000) NOT NULL,
    PRIMARY KEY ( `id` )
    ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare le preferenze sui cookie
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_leggeCookie` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `lingua` VARCHAR( 55 ) NOT NULL,
        `attivaBarraCookie` VARCHAR( 55 ) NOT NULL,
        `durataCookie` SMALLINT( 6 ) NOT NULL,
        `testoBarraCookie` TEXT( 1000 ) NOT NULL,
        `headCodiciCookie` TEXT( 1000 ) NOT NULL,
        `fineBodyCookie` TEXT( 1000 ) NOT NULL,
        `testoPulsanteAccetto` VARCHAR( 255 ) NOT NULL,
        `testoPulsanteNonAccetto` VARCHAR( 255 ) NOT NULL,
        `testoPulsanteMaggioriInformazioni` VARCHAR( 255 ) NOT NULL,
        `mostraPulsanteNonAccetto` VARCHAR( 255 ) NOT NULL,
        `mostraPulsanteMaggioriInformazioni` VARCHAR( 255 ) NOT NULL,
        `paginaMaggioriInformazioni` INT(11) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare le impostazioni del footer
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_footer` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `lingua` VARCHAR( 55 ) NOT NULL,
        `testo` TEXT( 65000 ) NOT NULL,
        `attivaFooterSuperiore` TEXT( 65000 ) NOT NULL,
        `numeroColonne` TEXT( 1000 ) NOT NULL,
        `colonna1` VARCHAR( 255 ) NOT NULL,
        `colonna2` VARCHAR( 255 ) NOT NULL,
        `colonna3` VARCHAR( 255 ) NOT NULL,
        `colonna4` VARCHAR( 255 ) NOT NULL,
        `titoloColonna1` VARCHAR( 255 ) NOT NULL,
        `titoloColonna2` VARCHAR( 255 ) NOT NULL,
        `titoloColonna3` VARCHAR( 255 ) NOT NULL,
        `titoloColonna4` VARCHAR( 255 ) NOT NULL,
        `testoAggiuntivoColonna1` TEXT( 10000 ) NOT NULL,
        `testoAggiuntivoColonna2` TEXT( 10000 ) NOT NULL,
        `testoAggiuntivoColonna3` TEXT( 10000 ) NOT NULL,
        `testoAggiuntivoColonna4` TEXT( 10000 ) NOT NULL,
        `coloreFooterInferiore` VARCHAR( 255 ) NOT NULL,
        `coloreFooterSuperiore` VARCHAR( 255 ) NOT NULL,
        `coloreTestiMenu` VARCHAR( 255 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    /*
     * query creazione tabella per memorizzare le opzioni di visualizzazione delle testimonianze,
     * un domani consentirà di avere diversi visualizzatori di testimonianze
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_visualizzatoriTestimonianze` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL,
        `spazioOccupato` VARCHAR(55) DEFAULT 'col-12',
        `descrizione` VARCHAR(55) DEFAULT '',
        `tipoVisualizzazione` VARCHAR( 255 ) DEFAULT 'tradizionale',
        `elementiPerRiga` SMALLINT (11) DEFAULT 2,
        `mostraImmagini` VARCHAR( 255 ) DEFAULT 'si',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare le testimonianze
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_testimonianze` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `idVisualizzatoreTestimonianze` INT( 11 ) NOT NULL,
        `posizione` SMALLINT ( 6 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL,
        `autore` VARCHAR( 255 ) NOT NULL,
        `immagine` VARCHAR( 255 ) NOT NULL,
        `ruolo` VARCHAR( 255 ) NOT NULL,
        `azienda` VARCHAR( 255 ) NOT NULL,
        `email` VARCHAR( 255 ) NOT NULL,
        `consensoPubblicazione` VARCHAR( 55 ) NOT NULL,
        `testo` TEXT( 65000 ) NOT NULL,
        `stelle` SMALLINT ( 6 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;"; 
    
    /*
     * query creazione tabella per memorizzare le opzioni del sito
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_visualizzatoriProfili` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `mostraNome` VARCHAR(255) NOT NULL DEFAULT '',
        `spazioOccupato` VARCHAR(55) DEFAULT 'col-12',
        `descrizione` VARCHAR( 255 ) DEFAULT '',
        `aspetto` VARCHAR( 55 ) DEFAULT 'tradizionale',
        `aspectRatio` VARCHAR( 55 ) DEFAULT 'aspect-ratio-1-1',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare i profili
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_profili` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `idVisualizzatoreProfili` VARCHAR( 55 ) NOT NULL,
        `posizione` SMALLINT ( 6 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL,
        `immagine` VARCHAR( 255 ) NOT NULL,
        `ruolo` VARCHAR( 255 ) NOT NULL,
        `azienda` VARCHAR( 255 ) NOT NULL,
        `email` VARCHAR( 255 ) NOT NULL,
        `descrizione` TEXT( 65000 ) NOT NULL,
        `facebook` VARCHAR( 55 ) NOT NULL,
        `instagram` VARCHAR( 55 ) NOT NULL,
        `twitter` VARCHAR( 55 ) NOT NULL,
        `linkedin` VARCHAR( 55 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;"; 
    
    /*
     * query creazione tabella per memorizzare le mappe
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_mappe` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL,
        `spazioOccupato` VARCHAR(255) DEFAULT 'col-12',
        `indirizzo` VARCHAR( 255 ) DEFAULT '',
        `tipo` VARCHAR( 255 ) DEFAULT 'Semplice',
        `html` TEXT( 65000 ) ,
        `javascript` TEXT( 65000 ) ,
        `latitudine` VARCHAR( 55 ) DEFAULT '',
        `longitudine` VARCHAR( 55 ) DEFAULT '',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;"; 

    /*
     * query creazione tabella per memorizzare i contatori
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_contatori` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `spazioOccupato` VARCHAR( 255 ) DEFAULT 'col-12' ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per il componente confronto immagini
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_confrontoImmagini` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL,
        `spazioOccupato` VARCHAR( 255 ) DEFAULT 'col-12',
        `immagine1` VARCHAR( 255 ) DEFAULT '',
        `immagine2` VARCHAR( 255 ) DEFAULT '',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella contenente gli elementi dei contatori
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_elementiContatore` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idContatore` INT( 11 ) NOT NULL ,
        `posizione` smallint(6) NOT NULL,        
        `etichetta` VARCHAR( 255 ) NOT NULL ,
        `colore` VARCHAR( 55 ) NOT NULL,
        `icona` VARCHAR( 255 ) NOT NULL,
        `dimensioneIcona` VARCHAR( 255 ) NOT NULL,
        `valore` VARCHAR( 55 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    /*
     * query creazione tabella per memorizzare le griglie di immagini
     */    
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_griglieImmagini` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `descrizione` VARCHAR( 255 ) DEFAULT '',
        `spazioOccupato` VARCHAR( 255 ) DEFAULT 'col-12',
        `classeElementi` VARCHAR( 255 ) DEFAULT 'col-md-4',
        `animazioneOnHover` VARCHAR( 255 ) DEFAULT '',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_immaginiGriglia` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `idGriglia` INT (11) NOT NULL,
        `classeElemento` varchar(255) NOT NULL,
        `nome` varchar(255) NOT NULL,
        `descrizione` TEXT(65000) NOT NULL,
        `percorsoImmagine` varchar(255) NOT NULL,
        `tagAltImmagine` varchar(255) NOT NULL,
        `link` varchar(255) NOT NULL,
        `posizione` smallint(6) NOT NULL,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query per la creazione delle query comuni
     */

    //query per creare la tabella utenti
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_utenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `email` VARCHAR( 255 ) NOT NULL ,
        `password` VARCHAR( 255 ) NOT NULL ,
        `ruolo` VARCHAR( 255 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `cognome` VARCHAR( 255 ) NOT NULL ,
        `sesso` VARCHAR( 55 ) NOT NULL ,
        `foto` VARCHAR( 255 ) NOT NULL ,
        `descrizione` TEXT( 5000 ) NOT NULL ,
        `note` TEXT( 1000 ) NOT NULL ,
        `via` VARCHAR( 255 ) NOT NULL ,
        `citta` VARCHAR( 255 ) NOT NULL ,
        `cap` VARCHAR( 255 ) NOT NULL ,
        `dataNascita` DATE ,
        `luogoNascita` VARCHAR( 255 ) NOT NULL ,
        `provinciaNascita` VARCHAR( 255 ) NOT NULL ,
        `telefono` VARCHAR( 255 ) NOT NULL ,
        `codiceFiscale` VARCHAR( 255 ) NOT NULL ,
        `partitaIva` VARCHAR( 255 ) NOT NULL,
        `organizzazione` VARCHAR( 255 ) NOT NULL,
        `sitoWeb` VARCHAR( 255 ) NOT NULL ,
        `pec` VARCHAR( 255 ) NOT NULL ,
        `codiceInterscambio` VARCHAR( 255 ) NOT NULL ,
        `stato` VARCHAR( 255 ) NOT NULL ,
        `ricezioneMail` VARCHAR( 255 ) NOT NULL ,
        `etichetta` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL,
        `ultimoLogin` DATE NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    /*
     * query creazione tabella per memorizzare le configurazioni del colore
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_configurazioniAspetto` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR (255) NOT NULL,
        `descrizione` VARCHAR (255) NOT NULL,
        `selezionataCms` VARCHAR (255) NOT NULL,
        `selezionataAdmin` VARCHAR (255) NOT NULL,
        `selezionataDoc` VARCHAR (255) NOT NULL,
        `logo` VARCHAR (255) NOT NULL,
        `logoMobile` VARCHAR (255) NOT NULL,
        `favicon` VARCHAR (55) NOT NULL,
        `altezzaLogo` VARCHAR (55) NOT NULL,
        `larghezzaLogo` VARCHAR (55) NOT NULL,
        `altezzaLogoXl` VARCHAR (55) NOT NULL,
        `larghezzaLogoXl` VARCHAR (55) NOT NULL,
        `sfondoBarraMenu` VARCHAR (255) NOT NULL,
        `coloreTestoBarraMenu` VARCHAR (255) NOT NULL,
        `linkFont` VARCHAR (255) NOT NULL,
        `fontIntestazioni` VARCHAR (255) NOT NULL,
        `fontTesti` VARCHAR (255) NOT NULL,
        `colorePrimario` VARCHAR (255) NOT NULL,
        `coloreSecondario` VARCHAR (255) NOT NULL,
        `coloreSuccess` VARCHAR (255) NOT NULL,
        `coloreInfo` VARCHAR (255) NOT NULL,
        `coloreLight` VARCHAR (255) NOT NULL,
        `coloreDark` VARCHAR (255) NOT NULL,
        `coloreWarning` VARCHAR (255) NOT NULL,
        `coloreDanger` VARCHAR (255) NOT NULL,
        `colorePrimarioHover` VARCHAR (255) NOT NULL,
        `coloreSecondarioHover` VARCHAR (255) NOT NULL,
        `coloreSuccessHover` VARCHAR (255) NOT NULL,
        `coloreInfoHover` VARCHAR (255) NOT NULL,
        `coloreLightHover` VARCHAR (255) NOT NULL,
        `coloreDarkHover` VARCHAR (255) NOT NULL,
        `coloreWarningHover` VARCHAR (255) NOT NULL,
        `coloreDangerHover` VARCHAR (255) NOT NULL,
        `colorePrimarioActive` VARCHAR (255) NOT NULL,
        `coloreSecondarioActive` VARCHAR (255) NOT NULL,
        `coloreSuccessActive` VARCHAR (255) NOT NULL,
        `coloreInfoActive` VARCHAR (255) NOT NULL,
        `coloreLightActive` VARCHAR (255) NOT NULL,
        `coloreDarkActive` VARCHAR (255) NOT NULL,
        `coloreWarningActive` VARCHAR (255) NOT NULL,
        `coloreDangerActive` VARCHAR (255) NOT NULL,
        `breakingPointsXs` VARCHAR (255) NOT NULL,
        `breakingPointsMd` VARCHAR (255) NOT NULL,
        `breakingPointsLg` VARCHAR (255) NOT NULL,
        `breakingPointsXl` VARCHAR (255) NOT NULL,
        `attivaColonnaSinistra` VARCHAR (255) NOT NULL,
        `colonnaSinistra` VARCHAR (255) NOT NULL,
        `colonnaCentrale` VARCHAR (255) NOT NULL,
        `attivaColonnaDestra` VARCHAR (255) NOT NULL,
        `colonnaDestra` VARCHAR (255) NOT NULL,
        `aspettoComponentiLaterali` VARCHAR (255) NOT NULL,
        PRIMARY KEY ( `id` )
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    // query per inserire le configurazioni dell'aspetto: logo, colori e altre impostazioni
    $queryTabelleComuni[count($queryTabelleComuni)] = "INSERT INTO `geec_configurazioniAspetto`  
        VALUES (1, 'Configurazione di base','Stai usando la configurazione predefinita dei colori di Geecom', 'si','no','no','template/logoGeecom.svg','template/logo-mobile.svg','template/favicon.ico', '50px', '200px', '50px', '300px', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap','font-family:\'Raleway\', sans-serif;','font-family:\'Roboto\', sans-serif;', '#018394', '#dd3b15', '#28a745', '#335C67', '#f8f9fa', '#0d1b1e', '#f7a616', '#dc3545','#016c7a', '#b53112', '#218838', '#2f5453', '#e2e6ea', '#0c191c','#cb8813', '#c82333','#01606c', '#a12b10', '#1e7e34','#2a4c55', '#dae0e5', '#0b1719', '#b47b11', '#bd2130','576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (2, 'Monocromo Verde', 'Stai usando la configurazione Monocromo Verde, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no', 'no', 'immagini/altro/logoverde.svg','template/logo-mobile.svg','template/favicon.ico', '50px', '200px', '50px', '300px', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;   ', 'font-family:\'Roboto\', sans-serif;    ', '#00a86b', '#6bbf59', '#4cb944', '#095256', '#f6f8ff', '#073b3a', '#f6ae2d', '#ed1c24', '#17af78', '#78c468', '#5cbf55', '#1f6165', '#fefeff', '#1d4c4b', '#f6b540', '#ee3037', '#009962', '#62ae51', '#46a93e', '#094b4f', '#ebebeb', '#073635', '#e09f29', '#d81a21', '576px','768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (3, 'Monocromo Rosso', 'Stai usando la configurazione Monocromo Rosso, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no', 'no', 'immagini/altro/logorosso.svg','template/logo-mobile.svg','template/favicon.ico', '50px', '200px', '50px', '300px', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;    ', 'font-family:\'Roboto\', sans-serif;     ', '#ff0800', '#a31621', '#4cb944', '#1f7a8c', '#fdfffc', '#020100', '#ffba08', '#ed1c24', '#ff1e17', '#ab2b35', '#5cbf55', '#338696', '#fefeff', '#191817', '#ffc01e', '#ee3037', '#e80800', '#95141e', '#46a93e', '#1d6f80', '#ebebeb', '#010100', '#e8aa08', '#d81a21', '576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (4, 'Monocromo Nero', 'Stai usando la configurazione Monocromo Nero, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no', 'no', 'immagini/altro/logonero.svg','template/logo-mobile.svg','template/favicon.ico', '50px', '200px', '50px', '300px', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;     ', 'font-family:\'Roboto\', sans-serif;      ', '#000f08', '#637074', '#4cb944', '#90a9b7', '#fcfcfc', '#000000', '#f9c22e', '#f22b29', '#17241e', '#717d80', '#5cbf55', '#9ab0b9', '#ffffff', '#191817', '#f9c741', '#f33e3c', '#000022', '#5a666a', '#46a93e', '#839aa7', '#e7e8e7', '#000000', '#e3b12a', '#dc2826', '576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (5, 'Monocromo Blu', 'Stai usando la configurazione Monocromo Blu, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no', 'no','immagini/altro/logoblu.svg','template/logo-mobile.svg','template/favicon.ico', '50px', '200px', '50px', '300px', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;      ', 'font-family:\'Roboto\', sans-serif;       ', '#1034a6', '#052f5f', '#60992d', '#81a4cd', '#f0f1ee', '#0d1317', '#ffc857', '#d62839', '#2546ae', '#1b416d', '#6ea240', '#8cacd1', '#fcfcfb', '#23282c', '#ffcd66', '#d93b4b', '#0f3097', '#052b57', '#588c29', '#7696bb', '#e0e2db', '#0b1013', '#e8b650', '#c32534', '576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (6, 'Monocromo Giallo', 'Stai usando la configurazione Monocromo Giallo, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no','no', 'immagini/altro/logogiallo.svg','template/logo-mobile.svg','template/favicon.ico', '50px', '200px', '50px', '300px', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;', 'font-family:\'Roboto\', sans-serif;  ', '#ffa900', '#d84a05', '#4cb944', '#335c67', '#fcfcfb', '#220901', '#eecf6d', '#990033', '#ffb017', '#db5a1b', '#5cbf55', '#456a74', '#fefefe', '#361f18', '#efd37a', '#a21745', '#e89a00', '#c54405', '#46a93e', '#2f545e', '#e6e6e5', '#1f0901', '#d9bd64', '#8c002f', '576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (7, 'Monocromo Viola', 'Stai usando la configurazione Monocromo Viola, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no', 'no', 'immagini/altro/logoviola.svg','template/logo-mobile.svg','template/favicon.ico', '50px', '200px', '50px', '300px', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', serif;  ', 'font-family:\'Roboto\', sans-serif;  ', '#6457a6', '#afa2ff', '#679436', '#cfb3cd', '#f2f6fb', '#0c0f0a', '#ffe347', '#990033', '#7266ae', '#b6aaff', '#749d48', '#d3b9d1', '#f5f9fc', '#222420', '#ffe557', '#a21745', '#5b5097', '#a094e8', '#5e8732', '#bda3bb', '#d6dce4', '#0b0e0a', '#e8cf41', '#8c002f', '576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (8, 'Monocromo Arancio', 'Stai usando la configurazione Monocromo Arancio, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no', 'no', 'immagini/altro/logoarancio.svg','template/logo-mobile.svg','template/favicon.ico', '50px', '200px', '50px', '300px', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif; ', 'font-family:\'Roboto\', sans-serif;   ', '#ff4f00', '#ff9505', '#9bc53d', '#197278', '#fffffc', '#000000', '#f7cb15', '#a30000', '#ff5f17', '#ff9e1b', '#a4ca4e', '#2d7e84', '#ffffff', '#000000', '#f7cf2a', '#ab1717', '#e84800', '#e88805', '#8db438', '#17686e', '#e8e8e6', '#000000', '#e1b914', '#950000', '576px','768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (9, 'Monocromo Acqua', 'Stai usando la configurazione Monocromo Acqua, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no', 'no', 'immagini/altro/logoacqua.svg','template/logo-mobile.svg','template/favicon.ico', '50px', '200px', '50px', '300px', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;  ', 'font-family:\'Roboto\', sans-serif;    ', '#1ca9c9', '#086788', '#3ec300', '#4e4d5c', '#fff9ed', '#011627', '#f0c808', '#dd1c1a', '#30b0cd', '#086788', '#4fc817', '#5e5d6a', '#fffdfa', '#182b3a', '#f1cd1e', '#e0302e', '#1a9ab7', '#075570', '#39b200', '#40404c', '#e8dcbe', '#011424', '#dbb608', '#c91a18', '576px','768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (10, 'Configurazione di base Admin','Stai usando la configurazione predefinita dei colori di Geecom', 'no','si','no','template/logoGeecom.svg','template/logo-mobile.svg','template/favicon.ico', '50px', '200px', '50px', '300px', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap','font-family:\'Raleway\', sans-serif;','font-family:\'Roboto\', sans-serif;', '#018394', '#dd3b15', '#28a745', '#335C67', '#f8f9fa', '#0d1b1e', '#f7a616', '#dc3545','#016c7a', '#b53112', '#218838', '#2f5453', '#e2e6ea', '#0c191c','#cb8813', '#c82333','#01606c', '#a12b10', '#1e7e34','#2a4c55', '#dae0e5', '#0b1719', '#b47b11', '#bd2130','576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link')";

    //query per creare la tabella contenente le sezioni a due colonne
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_sezioniADueColonne` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `proporzioni` VARCHAR( 255 ) DEFAULT 'col-md-6, col-md-6',
        `allineamento` VARCHAR(255) DEFAULT 'd-flex align-items-start',
        `idComponenteSezione1` INT( 11 ) DEFAULT 0 ,
        `idElementoSezione1` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione2` INT( 11 ) DEFAULT 0 ,
        `idElementoSezione2` INT( 11 ) DEFAULT 0 ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella contenente le sezioni a tre colonne
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_sezioniATreColonne` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `proporzioni` VARCHAR( 255 ) DEFAULT 'col-md-4, col-md-4, col-md-4',
        `allineamento` VARCHAR(255) DEFAULT 'd-flex align-items-start',
        `idComponenteSezione1` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione2` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione3` INT( 11 ) DEFAULT 0 ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //imposta il valore iniziale dell'id a 500, serve per evitare che in una pagina ci siano sezioni a due colonne, tre colonne o quattro colonne con lo stesso id
    $queryTabelleComuni[count($queryTabelleComuni)]  = "ALTER TABLE `geec_sezioniATreColonne` AUTO_INCREMENT=250;";
    
    //query per creare la tabella contenente le sezioni a quattro colonne
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_sezioniAQuattroColonne` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `proporzioni` VARCHAR( 255 ) DEFAULT 'col-md-6, col-md-6',
        `allineamento` VARCHAR(255) DEFAULT 'd-flex align-items-start',
        `idComponenteSezione1` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione2` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione3` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione4` INT( 11 ) DEFAULT 0 ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //imposta il valore iniziale dell'id a 500, serve per evitare che in una pagina ci siano sezioni a due colonne, tre colonne o quattro colonne con lo stesso id
    $queryTabelleComuni[count($queryTabelleComuni)]  = "ALTER TABLE `geec_sezioniAQuattroColonne` AUTO_INCREMENT=500;";
    
    //query per creare la tabella dei profili social
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_profiliSocial` (
            `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
            `facebook` VARCHAR( 255 ) NOT NULL ,
            `instagram` VARCHAR( 255 ) NOT NULL ,
            `youtube` VARCHAR( 255 ) NOT NULL ,
            `patreon` VARCHAR( 255 ) NOT NULL ,
            `ticToc` VARCHAR( 255 ) NOT NULL ,
            `linkedin` VARCHAR( 255 ) NOT NULL ,
            `twitter` VARCHAR( 255 ) NOT NULL ,
            `whatsapp` VARCHAR( 255 ) NOT NULL ,
            `mostraChatWhatsapp` VARCHAR( 55 ) NOT NULL ,
            `telegram` VARCHAR( 255 ) NOT NULL ,
            `mostraChatTelegram` VARCHAR( 55 ) NOT NULL ,
            PRIMARY KEY ( `id` )
            ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella dei gruppi
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_gruppi` (
            `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
            `nome` VARCHAR( 255 ) NOT NULL ,
            `tipo` VARCHAR( 255 ) NOT NULL ,
            `descrizione` VARCHAR( 255 ) NOT NULL,
            `dataCreazione` DATE NOT NULL,
            PRIMARY KEY ( `id` )
            ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella che associa i gruppi agli utenti
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_gruppiUtenti` (
        `idGruppoUtente` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `idUtente` INT( 11 ) NOT NULL ,
        `idGruppo` INT( 11 ) NOT NULL ,
        PRIMARY KEY ( `idGruppoUtente` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella categorie
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_categorie` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `categoriaMadre` INT( 11 ) NOT NULL,
        `categoriaRiferimento` INT( 11 ) NOT NULL,
        `tipo` VARCHAR( 55 ) NOT NULL ,
        `lingua` VARCHAR( 55 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `alias` VARCHAR( 255 ) NOT NULL ,
        `titoloPagina` VARCHAR( 255 ) NOT NULL ,
        `metaDescrizione` VARCHAR( 255 ) NOT NULL ,
        `cssGenerato` TEXT( 65000 ) NOT NULL ,
        `cssAggiuntivo` TEXT( 65000 ) NOT NULL ,
        `foto` VARCHAR( 255 ) NOT NULL ,
        `punteggioSeo` VARCHAR( 255 ) NOT NULL ,
        `tipoVisualizzazione` VARCHAR( 255 ) NOT NULL ,
        `numeroArticoliPerPagina` INT( 11 ),
        `posizione` SMALLINT( 6 ),
        `ordinamento` VARCHAR( 255 ),
        `dataCreazione` DATE NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella risorse
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecB_risorse` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `password` VARCHAR( 255 ) NOT NULL ,
        `percorso` VARCHAR( 255 ) NOT NULL ,
        `descrizione` VARCHAR( 255 ) NOT NULL ,
        `immagine` VARCHAR( 255 ) NOT NULL ,
        `categoria` INT( 11 ) NOT NULL ,
        `posizione` INT( 11 ) NOT NULL ,
        `numeroDownload` INT( 11 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella che associa le categorie ai contenuti
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_associazioneCategorieContenuti` (
        `idCategoria` INT( 11 ) NOT NULL ,
        `idContenuto` INT( 11 ) NOT NULL ,
        `tipoContenuto` VARCHAR( 255 ) NOT NULL
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_reindirizzamenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `urlDaReindirizzare` VARCHAR( 255 ) NOT NULL ,
        `nuovoIndirizzo` VARCHAR( 255 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";    
    
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_prodotti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `installato` VARCHAR( 255 ) NOT NULL ,
        `versione` VARCHAR( 255 ) NOT NULL,
        `percorso` VARCHAR( 255 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    // query per inserire i prodotti Geecom
    $queryTabelleComuni[count($queryTabelleComuni)] = "INSERT INTO geec_prodotti (`id`,`nome`,`installato`,`versione`,`percorso`) VALUES
        (NULL,'CMS','si','{$infoGeecom["versione"]}','$cartellaAmministrazione'),
        (NULL,'Admin','si','{$infoGeecom["versione"]}','$cartellaAmministrazione'),
        (NULL,'Doc','no','','');";
    
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_impostazioniApp` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `attivaApp` VARCHAR (255) NOT NULL,
        `nomeCompleto` VARCHAR (255) NOT NULL,
        `nomeAbbreviato` VARCHAR (255) NOT NULL,
        `icona48` VARCHAR (255) NOT NULL,
        `icona96` VARCHAR (255) NOT NULL,
        `icona144` VARCHAR (255) NOT NULL,
        `icona192` VARCHAR (255) NOT NULL,
        `icona512` VARCHAR (255) NOT NULL,
        `colore` VARCHAR (255) NOT NULL,
        PRIMARY KEY ( `id` )
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare i moduli di contatto
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_form` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `spazioOccupato` VARCHAR( 55 ) DEFAULT 'col-12' ,
        `tipoConfermaMessaggioInviato` VARCHAR( 255 ) DEFAULT 'Messaggio a video' ,        
        `emailNotificaAmministratore` VARCHAR( 255 ) DEFAULT '' ,
        `rispondiA` VARCHAR( 255 ) DEFAULT '' ,
        `oggettoNotificaAmministratore` VARCHAR( 255 ) DEFAULT 'Nuovo messaggio dal tuo sito $titoloSito' ,
        `testoMessaggioInviato` VARCHAR( 255 ) DEFAULT 'Grazie! Ti contatteremo quanto prima' ,
        `testoMessaggioErrore` VARCHAR( 255 ) DEFAULT '' ,
        `paginaRingraziamento` INT( 11 ) DEFAULT 0 ,
        `formInLinea` VARCHAR( 55 ) DEFAULT 'col-12' ,
        `testo` TEXT( 65000 ) ,
        `stampaLinkPaginaForm` VARCHAR( 55 ) DEFAULT 'no' ,
        `spuntaPrivacy` VARCHAR( 55 ) DEFAULT 'si' ,
        `linkPrivacy` VARCHAR( 255 ) DEFAULT 'index.php?alias=informativa-sulla-privacy' ,
        `azione` VARCHAR( 255 ) DEFAULT 'Invia email' ,
        `etichettaPulsante` VARCHAR( 255 ) DEFAULT 'Invia' ,
        `iconaPulsante` VARCHAR( 255 ) DEFAULT 'fas fa-paper-plane' ,
        `spazioOccupatoPulsante` VARCHAR( 255 ) DEFAULT '' ,
        `linkScriptEsterno` VARCHAR( 255 ) DEFAULT '' ,
        `linkScriptRicerca` VARCHAR( 255 ) DEFAULT '' ,    
        `usaAjax` VARCHAR( 55 ) DEFAULT 'no' ,
        `noteAggiuntive` VARCHAR( 255 ) DEFAULT '* campo obbligatorio',
        `contatoreInvii` INT( 11 ) DEFAULT 0 ,
        `attivaNotificaUtente` VARCHAR( 55 ) DEFAULT '' ,
        `campoEmailNotificaUtente` VARCHAR( 255 ) DEFAULT '' ,
        `nomeMittenteNotificaUtente` VARCHAR( 255 ) DEFAULT '' ,
        `emailMittenteNotificaUtente` VARCHAR( 255 ) DEFAULT '' ,
        `oggettoNotificaUtente` VARCHAR( 255 ) DEFAULT '' ,
        `templateEmailNotificaUtente` INT( 11 ) DEFAULT 0 ,
        `mostraTitoloComponente` VARCHAR( 55 ) DEFAULT 'si' ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare i messaggi inviati tramite form
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_messaggiForm` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idForm` INT( 11 ) NOT NULL,
        `testo` TEXT( 1000 ) NOT NULL ,
        `dataCreazione` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare gli elementi presenti in ogni modulo di contatto
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_elementiForm` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `idForm` INT(11) NOT NULL,
        `posizione` tinyINT(4) NOT NULL,
        `spazioOccupato` VARCHAR( 55 ) NOT NULL,
        `nome` varchar(255) NOT NULL,
        `etichetta` varchar(255) NOT NULL,
        `valore` varchar(255) NOT NULL,
        `placeholder` varchar(255) NOT NULL,
        `tipo` varchar(255) NOT NULL,
        `opzioni` varchar(255) NOT NULL,
        `obbligatorio` varchar(255) NOT NULL,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        
    /*
     * query creazione tabella per memorizzare i video
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_video` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `spazioOccupato` VARCHAR( 55 ) DEFAULT 'col-12' ,
        `stile` VARCHAR( 55 ) DEFAULT 'Solo video' ,
        `animazioneVideo` VARCHAR( 55 ) DEFAULT '' ,
        `animazioneTesto` VARCHAR( 55 ) DEFAULT '' ,
        `video` TEXT( 5000 ) ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per i visualizzatori di risorse
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_visualizzatoriRisorse` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL,
        `categoria` INT( 11 ) DEFAULT 0,
        `descrizione` VARCHAR( 255 ) DEFAULT '',
        `filtrabile` VARCHAR( 255 ) DEFAULT 'no',
        `aTuttaLarghezza` VARCHAR( 255 ) DEFAULT 'no',
        `senzaBordi` VARCHAR( 255 ) DEFAULT 'no',
        `classeElementi` VARCHAR( 255 ) DEFAULT 'portfolio col-sm-6 col-md-4',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
        
    /*
     * query creazione tabella per memorizzare le opzioni di visualizzazione delle gallerie,
     * un domani consentirà di avere diversi visualizzatori di testimonianze
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_visualizzatoriGallerie` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL,
        `idGalleria` INT( 11 ) DEFAULT 0 ,
        `spazioOccupato` VARCHAR(55) DEFAULT 'col-12',
        `tipoVisualizzazione` VARCHAR( 255 ) DEFAULT 'miniature',
        `aspectRatio` VARCHAR( 255 ) DEFAULT 'aspect-ratio-1-1',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare i div girevoli
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_contenutiGirevoli` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL,
        `spazioOccupato` VARCHAR(55) DEFAULT 'col-12',
        `classeElementi` VARCHAR( 255 ) DEFAULT 'col-12' ,
        `aspectRatioElementi` VARCHAR( 255 ) DEFAULT 'aspect-ratio-1-1',
        `mostraTitoloComponente` VARCHAR( 55 ) DEFAULT 'no',
        `immaginiInBackground` VARCHAR( 55 ) DEFAULT 'no',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_singoliContenutiGirevoli` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `idSezione` INT (11) NOT NULL,
        `classeElemento` varchar(255) NOT NULL,
        `nome` varchar(255) NOT NULL,
        `link` varchar(255) NOT NULL,
        `sfondoDivImmagine` varchar(255) NOT NULL,
        `coloreTestoDivImmagine` varchar(255) NOT NULL,
        `sfondoDivTesto` varchar(255) NOT NULL,
        `coloreTestoDivTesto` varchar(255) NOT NULL,
        `testo` TEXT(65000) NOT NULL,
        `immagine` varchar(255) NOT NULL,
        `etichetta` varchar(255) NOT NULL,
        `posizione` smallint(6) NOT NULL,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
        
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_templateEmail` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR (255) NOT NULL ,
        `css` TEXT (65000) NOT NULL ,
        `corpoMail` TEXT (65000) NOT NULL ,
        `footerMail` TEXT (65000) NOT NULL ,
        PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella contenente i dati delle utenze API
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE IF NOT EXISTS `geec_utenzeApi` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `attiva` VARCHAR( 55 ) NOT NULL,
        `nomeUtenza` VARCHAR( 255 ) NOT NULL ,
        `codiceSegreto` VARCHAR( 255 ) NOT NULL ,
        `permessiLettura` VARCHAR( 55 ) NOT NULL,
        `permessiScrittura` VARCHAR( 55 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * Tabella per l'immagazzinamento delle notifiche. Ogni notifica deve contenere
     *  - prodotto (Cms, Admin, Ask ecc)
     *  - tipo (notificaUtente o notificaAmministratore)
     *  idUtente (0 se si tratta di una notifica per amministratori)
     *  testo
     *  letta (vale si se è stata letta, altrimenti vale no)
     */ 
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_notifiche` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `prodotto` VARCHAR (255) NOT NULL ,
        `tipo` VARCHAR (255) NOT NULL,
        `idUtente` INT( 11 ) NOT NULL,
        `testo` TEXT (65000) NOT NULL,
        `link` VARCHAR (255) NOT NULL,
        `letta` VARCHAR (55) NOT NULL,
        `dataCreazione` DATETIME NOT NULL ,
        PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
        
    /*
     * Tabella per memorizzare lo storico delle azioni svolte sui prodotti Geecom. 
     * Ogni elemento deve contenere
     *  - prodotto (Cms, Admin, Ask ecc)
     *  - tipo (notificaUtente o notificaAmministratore)
     *  idUtente (0 se si tratta di una notifica per amministratori)
     *  testo
     *  letta (vale si se è stata letta, altrimenti vale no)
     */ 
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_elementoStoricoOperazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `prodotto` VARCHAR (255) NOT NULL ,
        `tipo` VARCHAR (255) NOT NULL,
        `testo` TEXT (65000) NOT NULL,
        `dataCreazione` DATETIME NOT NULL ,
        PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    $queryTabelleComuni[count($queryTabelleComuni)] = "INSERT INTO `geec_impostazioniApp` (`id`, `attivaApp`, `nomeCompleto`, `nomeAbbreviato`, `icona48`, `icona96`, `icona144`, `icona192`, `icona512`, `colore`) "
                                                    . "VALUES (NULL, 'no', '$titoloSito', '', 'immagini/altro/Geecom-icona-48.png', 'immagini/altro/Geecom-icona-96.png', 'immagini/altro/Geecom-icona-144.png', 'immagini/altro/Geecom-icona-192.png', 'immagini/altro/Geecom-icona-512.png', '');";
    
    $queryTabelleComuni[count($queryTabelleComuni)] = "INSERT INTO `geec_templateEmail` (`id`, `nome`, `css`, `corpoMail`, `footerMail`) VALUES
                                                        (NULL, 'Template sorgente', '      /* -------------------------------------\r\n          GLOBAL RESETS\r\n      ------------------------------------- */\r\n      \r\n      /* Classi personalizzate da aggiungere qui*/\r\n      \r\n      img {\r\n        border: none;\r\n        -ms-interpolation-mode: bicubic;\r\n        max-width: 100%; \r\n      }\r\n\r\n      body {\r\n        background-color: #f6f6f6;\r\n        font-family: sans-serif;\r\n        -webkit-font-smoothing: antialiased;\r\n        font-size: 14px;\r\n        line-height: 1.4;\r\n        margin: 0;\r\n        padding: 0;\r\n        -ms-text-size-adjust: 100%;\r\n        -webkit-text-size-adjust: 100%; \r\n      }\r\n\r\n      table {\r\n        border-collapse: separate;\r\n        mso-table-lspace: 0pt;\r\n        mso-table-rspace: 0pt;\r\n        width: 100%; }\r\n        table td {\r\n          font-family: sans-serif;\r\n          font-size: 14px;\r\n          vertical-align: top; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          BODY E CONTAINER\r\n      ------------------------------------- */\r\n\r\n      .body {\r\n        background-color: #f6f6f6;\r\n        width: 100%; \r\n      }\r\n\r\n      .container {\r\n        display: block;\r\n        margin: 0 auto !important;\r\n        max-width: 580px;\r\n        padding: 10px;\r\n        width: 580px; \r\n      }\r\n\r\n      .content {\r\n        box-sizing: border-box;\r\n        display: block;\r\n        margin: 0 auto;\r\n        max-width: 580px;\r\n        padding: 10px; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          HEADER, FOOTER, MAIN\r\n      ------------------------------------- */\r\n      .main {\r\n        background: #ffffff;\r\n        border-radius: 3px;\r\n        width: 100%; \r\n      }\r\n\r\n      .wrapper {\r\n        box-sizing: border-box;\r\n        padding: 20px; \r\n      }\r\n\r\n      .content-block {\r\n        padding-bottom: 10px;\r\n        padding-top: 10px;\r\n      }\r\n\r\n      .footer {\r\n        clear: both;\r\n        margin-top: 10px;\r\n        text-align: center;\r\n        width: 100%; \r\n      }\r\n        .footer td,\r\n        .footer p,\r\n        .footer span,\r\n        .footer a {\r\n          color: #999999;\r\n          font-size: 12px;\r\n          text-align: center; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          TIPOGRAFIA E LETTERING\r\n      ------------------------------------- */\r\n      h1,\r\n      h2,\r\n      h3,\r\n      h4 {\r\n        color: #000000;\r\n        font-family: sans-serif;\r\n        font-weight: 400;\r\n        line-height: 1.4;\r\n        margin: 0;\r\n        margin-bottom: 30px; \r\n      }\r\n\r\n      h1 {\r\n        font-size: 35px;\r\n        font-weight: 300;\r\n        text-align: center;\r\n        text-transform: capitalize; \r\n      }\r\n\r\n      p,\r\n      ul,\r\n      ol {\r\n        font-family: sans-serif;\r\n        font-size: 14px;\r\n        font-weight: normal;\r\n        margin: 0;\r\n        margin-bottom: 15px; \r\n      }\r\n        p li,\r\n        ul li,\r\n        ol li {\r\n          list-style-position: inside;\r\n          margin-left: 5px; \r\n      }\r\n\r\n      a {\r\n        color: #018394;\r\n        text-decoration: underline; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          PULSANTI\r\n      ------------------------------------- */\r\n      .btn {\r\n        box-sizing: border-box;\r\n        width: 100%; }\r\n        .btn > tbody > tr > td {\r\n          padding-bottom: 15px; }\r\n        .btn table {\r\n          width: auto; \r\n      }\r\n        .btn table td {\r\n          background-color: #ffffff;\r\n          border-radius: 5px;\r\n          text-align: center; \r\n      }\r\n        .btn a {\r\n          background-color: #ffffff;\r\n          border: solid 1px #018394;\r\n          border-radius: 5px;\r\n          box-sizing: border-box;\r\n          color: #018394;\r\n          cursor: pointer;\r\n          display: inline-block;\r\n          font-size: 14px;\r\n          font-weight: bold;\r\n          margin: 0;\r\n          padding: 12px 25px;\r\n          text-decoration: none;\r\n          text-transform: capitalize; \r\n      }\r\n\r\n      .btn-primary table td {\r\n        background-color: #018394; \r\n      }\r\n\r\n      .btn-primary a {\r\n        background-color: #018394;\r\n        border-color: #018394;\r\n        color: #ffffff; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          ALTRI STILI UTILI\r\n      ------------------------------------- */\r\n      .last {\r\n        margin-bottom: 0; \r\n      }\r\n\r\n      .first {\r\n        margin-top: 0; \r\n      }\r\n\r\n      .align-center {\r\n        text-align: center; \r\n      }\r\n\r\n      .align-right {\r\n        text-align: right; \r\n      }\r\n\r\n      .align-left {\r\n        text-align: left; \r\n      }\r\n\r\n      .clear {\r\n        clear: both; \r\n      }\r\n\r\n      .mt0 {\r\n        margin-top: 0; \r\n      }\r\n\r\n      .mb0 {\r\n        margin-bottom: 0; \r\n      }\r\n\r\n      .preheader {\r\n        color: transparent;\r\n        display: none;\r\n        height: 0;\r\n        max-height: 0;\r\n        max-width: 0;\r\n        opacity: 0;\r\n        overflow: hidden;\r\n        mso-hide: all;\r\n        visibility: hidden;\r\n        width: 0; \r\n      }\r\n\r\n      .powered-by a {\r\n        text-decoration: none; \r\n      }\r\n\r\n      hr {\r\n        border: 0;\r\n        border-bottom: 1px solid #f6f6f6;\r\n        margin: 20px 0; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          STILI RESPONSIVE E MOBILE FRIENDLY \r\n      ------------------------------------- */\r\n      @media only screen and (max-width: 620px) {\r\n        table[class=body] h1 {\r\n          font-size: 28px !important;\r\n          margin-bottom: 10px !important; \r\n        }\r\n        table[class=body] p,\r\n        table[class=body] ul,\r\n        table[class=body] ol,\r\n        table[class=body] td,\r\n        table[class=body] span,\r\n        table[class=body] a {\r\n          font-size: 16px !important; \r\n        }\r\n        table[class=body] .wrapper,\r\n        table[class=body] .article {\r\n          padding: 10px !important; \r\n        }\r\n        table[class=body] .content {\r\n          padding: 0 !important; \r\n        }\r\n        table[class=body] .container {\r\n          padding: 0 !important;\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .main {\r\n          border-left-width: 0 !important;\r\n          border-radius: 0 !important;\r\n          border-right-width: 0 !important; \r\n        }\r\n        table[class=body] .btn table {\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .btn a {\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .img-responsive {\r\n          height: auto !important;\r\n          max-width: 100% !important;\r\n          width: auto !important; \r\n        }\r\n      }\r\n\r\n      /* -------------------------------------\r\n          PRESERVA STILI HEAD\r\n      ------------------------------------- */\r\n      @media all {\r\n        .ExternalClass {\r\n          width: 100%; \r\n        }\r\n        .ExternalClass,\r\n        .ExternalClass p,\r\n        .ExternalClass span,\r\n        .ExternalClass font,\r\n        .ExternalClass td,\r\n        .ExternalClass div {\r\n          line-height: 100%; \r\n        }\r\n        .apple-link a {\r\n          color: inherit !important;\r\n          font-family: inherit !important;\r\n          font-size: inherit !important;\r\n          font-weight: inherit !important;\r\n          line-height: inherit !important;\r\n          text-decoration: none !important; \r\n        }\r\n        #MessageViewBody a {\r\n          color: inherit;\r\n          text-decoration: none;\r\n          font-size: inherit;\r\n          font-family: inherit;\r\n          font-weight: inherit;\r\n          line-height: inherit;\r\n        }\r\n        .btn-primary table td:hover {\r\n          background-color: #016c7a !important; \r\n        }\r\n        .btn-primary a:hover {\r\n          background-color: #016c7a !important;\r\n          border-color: #016c7a !important; \r\n        } \r\n      }', '<table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"body\">\r\n      <tr>\r\n        <td> </td>\r\n        <td class=\"container\">\r\n          <div class=\"content\">\r\n\r\n            <!-- START CONTAINER BIANCO CENTRATO -->\r\n            <table role=\"presentation\" class=\"main\">\r\n\r\n              <!-- START AREA MAIN CONTENT -->\r\n              <tr>\r\n                <td class=\"wrapper\">\r\n                  <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n				__intestazione_mail__\r\n				<tr>\r\n				  	<td> </td>\r\n				</tr>\r\n                    <tr>\r\n                      <td>\r\n				testo_da_inserire\r\n                      </td>\r\n                    </tr>\r\n                  </table>\r\n                </td>\r\n              </tr>\r\n\r\n            <!-- FINE AEREA MAIN CONTENT -->\r\n            </table>\r\n            <!-- FINE CONTAINE BIANCO CENTRATO -->', '            <!-- START FOOTER -->\r\n            <div class=\"footer\">\r\n              <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                <tr>\r\n                  <td class=\"content-block\">\r\n                    <span class=\"apple-link\">Geecom Ltd, Via, Città 00111</span>\r\n                    <br> Non vuoi piu ricevere questa mail? <a href=\"#\">Clicca qui</a>.\r\n                  </td>\r\n                </tr>\r\n                <tr>\r\n                  <td class=\"content-block powered-by\">\r\n                    Powered by <a href=\"#\">Geecom</a>.\r\n                  </td>\r\n                </tr>\r\n              </table>\r\n            </div>\r\n            <!-- FINE FOOTER -->'),
                                                        (NULL, 'Template base', '      /* -------------------------------------\r\n          GLOBAL RESETS\r\n      ------------------------------------- */\r\n      \r\n      /* Classi personalizzate da aggiungere qui*/\r\n      \r\n      img {\r\n        border: none;\r\n        -ms-interpolation-mode: bicubic;\r\n        max-width: 100%; \r\n      }\r\n\r\n      body {\r\n        background-color: #f6f6f6;\r\n        font-family: sans-serif;\r\n        -webkit-font-smoothing: antialiased;\r\n        font-size: 14px;\r\n        line-height: 1.4;\r\n        margin: 0;\r\n        padding: 0;\r\n        -ms-text-size-adjust: 100%;\r\n        -webkit-text-size-adjust: 100%; \r\n      }\r\n\r\n      table {\r\n        border-collapse: separate;\r\n        mso-table-lspace: 0pt;\r\n        mso-table-rspace: 0pt;\r\n        width: 100%; }\r\n        table td {\r\n          font-family: sans-serif;\r\n          font-size: 14px;\r\n          vertical-align: top; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          BODY E CONTAINER\r\n      ------------------------------------- */\r\n\r\n      .body {\r\n        background-color: #f6f6f6;\r\n        width: 100%; \r\n      }\r\n\r\n      .container {\r\n        display: block;\r\n        margin: 0 auto !important;\r\n        max-width: 580px;\r\n        padding: 10px;\r\n        width: 580px; \r\n      }\r\n\r\n      .content {\r\n        box-sizing: border-box;\r\n        display: block;\r\n        margin: 0 auto;\r\n        max-width: 580px;\r\n        padding: 10px; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          HEADER, FOOTER, MAIN\r\n      ------------------------------------- */\r\n      .main {\r\n        background: #ffffff;\r\n        border-radius: 3px;\r\n        width: 100%; \r\n      }\r\n\r\n      .wrapper {\r\n        box-sizing: border-box;\r\n        padding: 20px; \r\n      }\r\n\r\n      .content-block {\r\n        padding-bottom: 10px;\r\n        padding-top: 10px;\r\n      }\r\n\r\n      .footer {\r\n        clear: both;\r\n        margin-top: 10px;\r\n        text-align: center;\r\n        width: 100%; \r\n      }\r\n        .footer td,\r\n        .footer p,\r\n        .footer span,\r\n        .footer a {\r\n          color: #999999;\r\n          font-size: 12px;\r\n          text-align: center; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          TIPOGRAFIA E LETTERING\r\n      ------------------------------------- */\r\n      h1,\r\n      h2,\r\n      h3,\r\n      h4 {\r\n        color: #000000;\r\n        font-family: sans-serif;\r\n        font-weight: 400;\r\n        line-height: 1.4;\r\n        margin: 0;\r\n        margin-bottom: 30px; \r\n      }\r\n\r\n      h1 {\r\n        font-size: 35px;\r\n        font-weight: 300;\r\n        text-align: center;\r\n        text-transform: capitalize; \r\n      }\r\n\r\n      p,\r\n      ul,\r\n      ol {\r\n        font-family: sans-serif;\r\n        font-size: 14px;\r\n        font-weight: normal;\r\n        margin: 0;\r\n        margin-bottom: 15px; \r\n      }\r\n        p li,\r\n        ul li,\r\n        ol li {\r\n          list-style-position: inside;\r\n          margin-left: 5px; \r\n      }\r\n\r\n      a {\r\n        color: #018394;\r\n        text-decoration: underline; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          PULSANTI\r\n      ------------------------------------- */\r\n      .btn {\r\n        box-sizing: border-box;\r\n        width: 100%; }\r\n        .btn > tbody > tr > td {\r\n          padding-bottom: 15px; }\r\n        .btn table {\r\n          width: auto; \r\n      }\r\n        .btn table td {\r\n          background-color: #ffffff;\r\n          border-radius: 5px;\r\n          text-align: center; \r\n      }\r\n        .btn a {\r\n          background-color: #ffffff;\r\n          border: solid 1px #018394;\r\n          border-radius: 5px;\r\n          box-sizing: border-box;\r\n          color: #018394;\r\n          cursor: pointer;\r\n          display: inline-block;\r\n          font-size: 14px;\r\n          font-weight: bold;\r\n          margin: 0;\r\n          padding: 12px 25px;\r\n          text-decoration: none;\r\n          text-transform: capitalize; \r\n      }\r\n\r\n      .btn-primary table td {\r\n        background-color: #018394; \r\n      }\r\n\r\n      .btn-primary a {\r\n        background-color: #018394;\r\n        border-color: #018394;\r\n        color: #ffffff; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          ALTRI STILI UTILI\r\n      ------------------------------------- */\r\n      .last {\r\n        margin-bottom: 0; \r\n      }\r\n\r\n      .first {\r\n        margin-top: 0; \r\n      }\r\n\r\n      .align-center {\r\n        text-align: center; \r\n      }\r\n\r\n      .align-right {\r\n        text-align: right; \r\n      }\r\n\r\n      .align-left {\r\n        text-align: left; \r\n      }\r\n\r\n      .clear {\r\n        clear: both; \r\n      }\r\n\r\n      .mt0 {\r\n        margin-top: 0; \r\n      }\r\n\r\n      .mb0 {\r\n        margin-bottom: 0; \r\n      }\r\n\r\n      .preheader {\r\n        color: transparent;\r\n        display: none;\r\n        height: 0;\r\n        max-height: 0;\r\n        max-width: 0;\r\n        opacity: 0;\r\n        overflow: hidden;\r\n        mso-hide: all;\r\n        visibility: hidden;\r\n        width: 0; \r\n      }\r\n\r\n      .powered-by a {\r\n        text-decoration: none; \r\n      }\r\n\r\n      hr {\r\n        border: 0;\r\n        border-bottom: 1px solid #f6f6f6;\r\n        margin: 20px 0; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          STILI RESPONSIVE E MOBILE FRIENDLY \r\n      ------------------------------------- */\r\n      @media only screen and (max-width: 620px) {\r\n        table[class=body] h1 {\r\n          font-size: 28px !important;\r\n          margin-bottom: 10px !important; \r\n        }\r\n        table[class=body] p,\r\n        table[class=body] ul,\r\n        table[class=body] ol,\r\n        table[class=body] td,\r\n        table[class=body] span,\r\n        table[class=body] a {\r\n          font-size: 16px !important; \r\n        }\r\n        table[class=body] .wrapper,\r\n        table[class=body] .article {\r\n          padding: 10px !important; \r\n        }\r\n        table[class=body] .content {\r\n          padding: 0 !important; \r\n        }\r\n        table[class=body] .container {\r\n          padding: 0 !important;\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .main {\r\n          border-left-width: 0 !important;\r\n          border-radius: 0 !important;\r\n          border-right-width: 0 !important; \r\n        }\r\n        table[class=body] .btn table {\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .btn a {\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .img-responsive {\r\n          height: auto !important;\r\n          max-width: 100% !important;\r\n          width: auto !important; \r\n        }\r\n      }\r\n\r\n      /* -------------------------------------\r\n          PRESERVA STILI HEAD\r\n      ------------------------------------- */\r\n      @media all {\r\n        .ExternalClass {\r\n          width: 100%; \r\n        }\r\n        .ExternalClass,\r\n        .ExternalClass p,\r\n        .ExternalClass span,\r\n        .ExternalClass font,\r\n        .ExternalClass td,\r\n        .ExternalClass div {\r\n          line-height: 100%; \r\n        }\r\n        .apple-link a {\r\n          color: inherit !important;\r\n          font-family: inherit !important;\r\n          font-size: inherit !important;\r\n          font-weight: inherit !important;\r\n          line-height: inherit !important;\r\n          text-decoration: none !important; \r\n        }\r\n        #MessageViewBody a {\r\n          color: inherit;\r\n          text-decoration: none;\r\n          font-size: inherit;\r\n          font-family: inherit;\r\n          font-weight: inherit;\r\n          line-height: inherit;\r\n        }\r\n        .btn-primary table td:hover {\r\n          background-color: #016c7a !important; \r\n        }\r\n        .btn-primary a:hover {\r\n          background-color: #016c7a !important;\r\n          border-color: #016c7a !important; \r\n        } \r\n      }', '<table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"body\">\r\n      <tr>\r\n        <td>&nbsp;</td>\r\n        <td class=\"container\">\r\n          <div class=\"content\">\r\n\r\n            <!-- START CONTAINER BIANCO CENTRATO -->\r\n            <table role=\"presentation\" class=\"main\">\r\n\r\n              <!-- START AREA MAIN CONTENT -->\r\n              <tr>\r\n                <td class=\"wrapper\">\r\n                  <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n					<tr>\r\n					  	<td align=\"center\">\r\n							<img src=\"$urlSito/template/logo.svg\" alt=\"Nome sito\" width=\"220\" height=\"65\" border=\"0\" style=\"border:0; outline:none; text-decoration:none; display:block;\">  \r\n						</td>\r\n					</tr>\r\n					  <tr>\r\n					  	<td>&nbsp;</td>\r\n					  </tr>\r\n                    <tr>\r\n                      <td>\r\n				testo_da_inserire\r\n                      </td>\r\n                    </tr>\r\n                  </table>\r\n                </td>\r\n              </tr>\r\n\r\n            <!-- FINE AEREA MAIN CONTENT -->\r\n            </table>\r\n            <!-- FINE CONTAINE BIANCO CENTRATO -->', '            <!-- START FOOTER -->\r\n            <div class=\"footer\">\r\n              <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                <tr>\r\n                  <td class=\"content-block\">\r\n                    <span class=\"apple-link\">Geecom Ltd, Via, Città 00111</span>\r\n                    <br> Non vuoi piu ricevere questa mail? <a href=\"#\">Clicca quui</a>.\r\n                  </td>\r\n                </tr>\r\n                <tr>\r\n                  <td class=\"content-block powered-by\">\r\n                    Powered by <a href=\"#\">Geecom</a>.\r\n                  </td>\r\n                </tr>\r\n              </table>\r\n            </div>\r\n            <!-- FINE FOOTER -->'),
                                                        (NULL, 'Template vuoto', '', 'testo_da_inserire', '');";
    
    $data = date("Y-m-d H:i");
    
    // 	QUERY DI CONFIGURAZIONE
    
    // inizializzo la tabella impostazioniLingue
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_impostazioniLingue VALUES (NULL,'italiano', 'si','1','-1','6','','0','-1','0','','0','-1','0','','0','-1','0', '','0','-1','0')";

    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_impostazioniRicerca` (`id`, `elementiPerPagina`, `rimuoviUltimaLettera`, `salvaRicercheUtenti`, `cercaContenutiPerTitolo`, `cercaContenutiPerMetaDescrizione`, `cercaContenutiPerSottotitolo`, `cercaContenutiPerTesto`, `cercaProdottiPerNome`, `cercaProdottiPerMetaDescrizione`, `cercaProdottiPerTesto`, `cercaProdottiPerTestoDettagli`, `cercaProdottiPerMarca`, `cercaProdottiPerModello`) VALUES (NULL, '12', 'no', 'no', 'si', 'si', 'si', 'si', 'si', 'si', 'si', 'si', 'si', 'si');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_statistiche VALUES(NULL,0,'$data','$data','$data');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_inclusioni` (`id`, `inizioHead`, `fineHead`, `inizioBody`, `fineBody`, `footer`) VALUES (NULL, '', '', '', '', '')";

    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_componenti (`id`,`tipo`,`componenteArticolo`,`icona`,`nome`,`paginaGestione`,`tabellaRiferimento`,`script`,`versione`) VALUES
        (NULL,'pannelloLaterale','no','','Articoli piu letti','','','',''),
        (NULL,'pannelloLaterale','no','','Categorie','','','',''),
        (NULL,'pannelloLaterale','no','','Tag','','','',''),
        (NULL,'pannelloLaterale','no','','Form ricerca', '','','',''),
        (NULL,'pannelloLaterale','no','','Banner','','','',''),
        (NULL,'pannelloLaterale','no','','Ultime risorse','','','',''),
        (NULL,'pannelloLaterale','no','','Ultime gallerie','','','',''),
        (NULL,'pannelloLaterale','no','','Ultimi articoli','','','',''),
        (NULL,'pannelloLaterale','no','','HTML','htmlPersonalizzato','','',''),
        (NULL,'pannelloLaterale','no','','Categoria in evidenza','categoriaInEvidenza','','',''),
        (NULL,'pannelloLaterale','no','','Menu','menuLaterale','','',''),
        (NULL,'pannelloLaterale','no','','Testo','testoPersonalizzato','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_intestazione.svg','Intestazione','','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_testo.svg','Testo','','','',''),
        (NULL,'componenteDinamico','si','../template/img/componenti/icon_html.svg','Html','','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_codice.svg','Includi codice', '','','',''),
        (NULL,'componenteDinamico','si','../template/img/componenti/icon_immagine.svg','Immagine','','','',''),
        (NULL,'componenteDinamico','si','../template/img/componenti/icon_audio.svg','Audio','','','',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_video.svg','Video', 'video','geec_video','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_invito_azione.svg','Inviti all\'azione', 'invitoAzione','geec_invitiAzione','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_colonne_in_evidenza.svg','Colonne in evidenza','colonneInEvidenza','geec_colonneInEvidenza','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_portfolio.svg','Portfolio', 'portfolio','geec_portfolio','',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_form.svg','Form', 'form','geec_form','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_div_girevoli.svg','Contenuti girevoli','contenutiGirevoli','geec_contenutiGirevoli','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_slider.svg','Slider', 'slider','geec_slider','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_metro_slider.svg','Metro slider','metroSlider','geec_metroSlider','',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_lista.svg','Lista','lista','geec_liste','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_sezione_sdoppiata.svg','Sezione sdoppiata','sezioneSdoppiata','geec_sezioniSdoppiate','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_confronta_immagini.svg','Confronto immagini','confrontoImmagini','geec_confrontoImmagini','',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_tabella.svg','Tabella','tabella','geec_tabelle','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_tabella_prezzi.svg','Tabella prezzi','tabellaPrezzi','geec_tabellePrezzi','',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_galleria.svg','Visualizzatore galleria','visualizzatoreGalleria','geec_visualizzatoriGallerie','',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_griglia_contenuti.svg','Griglia contenuti','grigliaContenuti','geec_griglieImmagini','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_profili.svg','Profili','profili','geec_visualizzatoriProfili','',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_banner.svg','Banner','banner','geec_banner','',''),
        (NULL,'componenteDinamico','si','../template/img/componenti/icon_risorsa_singola.svg','Singola risorsa','','','',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_risorse.svg','Risorse','visualizzatoreRisorse','geec_visualizzatoriRisorse','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_testimonianze.svg','Testimonianze', 'testimonianze','geec_visualizzatoriTestimonianze','',''),
        (NULL,'pagine','no','../template/img/componenti/icon_blog.svg','Blog', 'blog','','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_articoli_blog.svg','Articoli dal blog','articoliDalBlog','geec_articoliDalBlog','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_mappa.svg','Mappa', 'mappa','geec_mappe','',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_contatore.svg','Contatore', 'contatore','geec_contatori','',''),
        (NULL,'componenteDinamicoNonConfigurabile','no','../template/img/componenti/icon_login.svg','Modulo login/registrati', '','','',''),
        (NULL,'esterno','no','../template/img/componenti/icon_popup.svg','Popup', 'popup','','',''),
        (NULL,'componenteStrutturaPagina','no','../template/img/componenti/icon_sezione_2.svg','Sezione a due colonne','','geec_sezioniADueColonne','',''),
        (NULL,'componenteStrutturaPagina','no','../template/img/componenti/icon_sezione_3.svg','Sezione a tre colonne','','geec_sezioniATreColonne','',''),
        (NULL,'componenteStrutturaPagina','no','../template/img/componenti/icon_sezione_4.svg','Sezione a quattro colonne','','geec_sezioniAQuattroColonne','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_social.svg','Profili social','','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_separatore.svg','Separatore','','','','');";
    
    // inserimento di componenti speciali che sono solo delle tabelle riassuntive visualizzate in home
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_componenti (`id`,`tipo`,`componenteArticolo`,`icona`,`nome`,`paginaGestione`,`tabellaRiferimento`,`script`,`versione`,`tabellaRiassuntivaHome`) VALUES
        (NULL,'tabellaRiassuntivaHome','no','','Vista commenti','vistaCommenti','','','','si'),
        (NULL,'tabellaRiassuntivaHome','no','','Statistiche contenuti','statisticheContenuti','','','','si')";
    
    //inizializzo la tabella pannello laterale con i tre componenti attivi previsti all'inizio
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_composizionePannelloLaterale (`id`,`idComponente`,`idElemento`,`nomePannello`,`posizione`,`nomeDaMostrare`,`testo`) VALUES
        (NULL,'1','0','destra','1','Articoli piu letti',''),
        (NULL,'2','0','destra','2','Categorie',''),
        (NULL,'8','0','destra','3','Ultimi articoli','');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_menu VALUES (NULL,0,0,'Menu principale','si')";
        
    //query per creare le voci di base (home e contatti) e le inserisce nel menu principale
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_vociMenu (`id`,`idMenu`,`idContenuto`,`vocePadre`,`mostraNomiColonne`,`testoAssociato`,`nome`,`icona`,`immagine`,`tipo`,`link`,`posizione`) VALUES
    (NULL,1,2,0,'','','Home','','','link a un contenuto','$urlSito',1),
    (NULL,1,3,0,'','','Chi siamo','','','link a un contenuto','index.php?alias=chi-siamo',2),
    (NULL,1,6,0,'','','Blog','','','link a un contenuto','index.php?alias=blog',3),
    (NULL,1,5,0,'','','Contatti','','','link a un contenuto','index.php?alias=contatti',4);";

    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geec_profiliSocial VALUES (NULL,'','','','','','','','','','','');";

    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geec_menuLaterale VALUES (NULL,'no',0);";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geec_blog VALUES (NULL,5,0,'classico','classico','aspect-ratio-16-9','aspect-ratio-16-9','si');";

    $data = date("Y-m-d H:i");
    //query per creare il footer. In Geecom viene visto come una sorta di contenuto
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_footer` VALUES (NULL, 'italiano', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','', '', '', '','bg-dark','bg-light','text-dark'),
                                                                                               (NULL, 'inglese', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','', '', '', '','bg-dark','bg-light','text-dark'),
                                                                                               (NULL, 'tedesco', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','', '', '', '','bg-dark','bg-light','text-dark'),
                                                                                               (NULL, 'francese', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','', '', '', '','bg-dark','bg-light','text-dark'),
                                                                                               (NULL, 'spagnolo', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','', '', '', '','bg-dark','bg-light','text-dark');";
    
    //query articolo di esempio
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_contenuti VALUES(NULL,0,'italiano','articolo','0','0','si','pubblicato','discreta','articolo.php','si','','Articolo di esempio','Articolo di esempio','si','','Il sottotitolo è importante per far capire alle persone di cosa si parla nell\'articolo e per avere un buon punteggio seo','articolo-di-esempio','','','<p>Articolo di esempio creato automaticamente al momento dell\'installazione, puoi modificarlo o eliminarlo dall\'area amministrativa. Grazie per aver scelto Geecom!</p>','si',0,'immagini/articoli/articolo.png','','Etichetta immagine','Geecom','$data','$data','$data','$data');";
    
    //creazione home page
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_contenuti VALUES(NULL,'0','italiano','pagina','0','0','si','pubblicato','scadente','homePage.php','si','','Home page','Home page','si','','','home-page','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`,`posizione`, `testo`, `script`,`idSezione`,`classeSezione`,`aTuttaLarghezza`) VALUES
(NULL, 25, 2, 'contenuto',1, 1, '','','','p-0','si');";
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`,`posizione`, `testo`,`script`,`idSezione`,`classeSezione`,`animazione`,`altreOpzioni`) VALUES
(NULL, 14, 2,'contenuto',0, 2, '<p>Questa &egrave; la tua home page, potrai modificarla dall\'area amministrativa: vai nella sezione pagine e poi clicca sul tasto modifica in corrispondenza della pagina Home page. Si aprir&agrave; 
una schermata che ti permetter&agrave; di modificare i vari componenti presenti (clicca sul tasto a forma di ingranaggio) e di aggiungerne di nuovi. Nel frattempo ti mostriamo alcune possibilit&agrave; che ti offre Geecom Cms: in questa pagina abbiamo attivato alcuni componenti, che tu puoi decidere di modificare o eliminare.</p>', '', '', '','fade-left','opzioneClasseColonne=col-12;')";
    
    // creazione delle sezioni sdoppiate
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geec_sezioniSdoppiate` (`id`,`nome`,`spazioOccupato`,`proporzioni`,`altezza`,`usaParallax`, `doveSiTrovaImmagine`, `doveSiTrovaImmagineSuMobile`, `animazioneImmagine`, `testo`, `classeDivImmagine`, `classeDivTesto`, `animazioneTesto`, `coloreDivTesto`, `immagine`,`tagAltImmagine`) VALUES
(NULL, 'Sezione 1', 'col-12','col-md-6, col-md-6', 'h50','no','destra','Sopra il testo','', '<h3>Nuove potenti funzionalit&agrave;</h3>\r\n<p style=\"text-align: justify;\"><strong>Garantiscila massima visibilit&agrave; ai tuoi prodotti e servizi</strong><br />Questo componente si chiama sezione sdoppiata, e consente di creare una sezione di pagina con un testo a da una parte e un\'immagine dall\'altra.</p>', '', '','', '#f1f1f1', 'immagini/altro/sezioneSdoppiata1.png',''),
(NULL, 'Sezione 2', 'col-12','col-md-6, col-md-6', 'h50','no','sinistra','Sopra il testo','', '<h3>Ottieni il massimo dal tuo sito web!</h3>\r\n<p style=\"text-align: justify;\">Puoi scegliere di mettere la foto a destra o a sinistra, quanto spazio deve occupare l\'immagine e il testo, quanto spazio verticale deve occupare. <strong>Solo questo componente ti mette a disposizione oltre 30 combinazioni!</strong></p>', '', '','', '#f1f1f1', 'immagini/altro/sezioneSdoppiata2.png','');";
    
    // le due sezioni sdoppiate vengono inserite nella home
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`,`tipoElemento`, `idElemento`, `posizione`, `testo`, `script`,`idSezione`,`classeSezione`,`aTuttaLarghezza`) "
    . "VALUES (NULL, 28, 2, 'contenuto',1, 3, '', '', '', 'p-0','si'),"
            ."(NULL, 28, 2, 'contenuto',2, 4, '', '', '', 'p-0','si');";
    
    // creazione del componente lista
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geec_liste` (`id`, `nome`, `descrizione`, `spazioOccupato`, `icona`, `tipoVisualizzazione`) VALUES
(NULL, 'I vantaggi di Geecom', 'Con il componente lista puoi creare elenchi di vario tipo, nell&#39;esempio puoi vedere i punti di forza di Geecom', 'col-12', 'fas fa-check-circle fa-3x', 'sequenza, due colonne');";
        
    // inserisco gli elementi nella lista
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geec_elementiLista` (`id`, `idLista`, `classeElemento`, `nome`, `descrizione`, `posizione`) VALUES
(1, 1, '', '35 componenti', '<p>Hai a disposizione 35 componenti per arricchire e personalizzare le pagine del tuo sito. Dallo slider al portfolio, dai contatori alle liste, tutti i componenti sono progettati integrarsi al meglio e funzionare in maniera sinergica.</p>', 1),
(2, 1, '', '9 configurazioni colore', '<p>Appena installato Geecom dispone di 9 configurazioni cromatiche pronte all’uso. Personalizzale, oppure duplicale e modificale a piacimento per creare la tua configurazione preferita.</p>', 2),
(3, 1, '', 'Analisi SEO integrata', '<p>Ogni contenuto creato in Geecom viene analizzato e confrontato con le linee guida dei principali motori di ricerca. Il CMS offre  automaticamente utili suggerimenti per migliorarli ed ottenere un posizionamento ottimale.</p>', 3),
(4, 1, '', '9 possibili aspetti', '<p>Personalizza rapidamente l’aspetto generale del tuo sito scegliendo fra 7 configurazioni già pronte: menu a scomparsa, menu centrale, menu a sinistra e molti altri. Scegli quello che più ti piace e cambialo con la rapidità di un click!</p>', 4),
(5, 1, '', 'Sistema di statistiche', '<p>Grazie alle statistiche potrai conoscere in che modo gli utenti interagiscono con il tuo sito: potrai sapere quali sono le pagine più visitate, i banner più cliccati e tanto altro.</p>', 5),
(6, 1, '', 'Multilingua', '<p>Creare un sito multilingua è facile e intuitivo: non devi far altro che attivare le lingue in cui vuoi tradurre il tuo sito e dedicarti ai contenuti!</p>', 6)";
    
    // inserisco nella home la lista
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `script`, `idSezione`, `classeSezione`) "
    . "VALUES (NULL, 27, 2, 'contenuto',1, 5, '', '', '', '')";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geec_invitiAzione` (`id`, `nome`, `percorsoImmagine`, `altezza`, `testo`, `linkPulsante`, `stilePulsante`, `titoloPulsante`, `numeroClick`, `dataCreazione`, `dataUltimoClick`) VALUES
(NULL, 'Invito 1', 'immagini/altro/invitoAzione.png', 'h20','<h2 style=\"text-align: center;\">Coinvolgi il tuo pubblico</h2>\r\n<p style=\"text-align: center;\">Personalizza questo spazio</p>','#','btn btn-primary leggi-tutto mt-3','Clicca qui',0,'2018-12-01 10:00','2018-12-01 10:00');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `script`, `idSezione`, `classeSezione`) VALUES
(NULL, 20, 2,'contenuto', 1, 6, '', '', '', 'text-white');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `script`, `idSezione`, `classeSezione`) VALUES
(NULL, 22, 2, 'contenuto',1, 7, '', '', '', '');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geec_slider` (`id`, `nome`, `tipoTransizione`, `spazioOccupato`, `altezza`,`mostraFreccette`,`mostraPuntiNavigazione`,`autoplay`,`slideMostrateSuDesktop`,`slideMostrateSuTablet`, `slideMostrateSuSmartphone`) VALUES
                                                                (1, 'Slider home', 'fadeInDown','col-12','h50','no','si','si',1,1,1);";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geec_slide` (`id`, `idSlider`, `posizione`, `nome`, `testo`, `tipo`, `percorsoFileMultimediale`, `link`, `overlay`, `gradiente`, `linkPulsante`, `stilePulsante`, `titoloPulsante`, `numeroClick`, `dataCreazione`, `dataUltimoClick`) VALUES
(1, 1, 1, 'Uno', '<h1 style=\"text-align: center;\">Benvenuto sul tuo sito web!</h1>\r\n<p style=\"text-align: center;\">inizia a personalizzare questa pagina dal pannello di controllo</p>\r\n', 'sfondo', 'immagini/slider/slide1.png', '', '', '', '$linkAreaRiservata', 'btn btn-primary leggi-tutto mt-3', 'Pannello di controllo', 0, '2018-01-01 08:00:00', '2018-01-01 08:00:00'),
(2, 1, 2, 'Due', '<h1 style=\"text-align: center;\">L\'analisi dei dati &egrave; fondamentale!</h1>\r\n<p>Per questo motivo Geecom ti consente di capire l\'efficacia di uno slider salvando il numero di click che riceve ogni slide</p>', 'sfondo', 'immagini/slider/slide2.png', '', '', '', '', 'btn btn-primary leggi-tutto mt-3', '', 0, '2018-01-01 08:00:00', '2018-01-01 08:00:00'),
(3, 1, 3, 'Tre', '<h1 style=\"text-align: center;\">Dai spazio alla creativit&agrave;</h1>\r\n<p style=\"text-align: center;\">Puoi personalizzare tutto ci&ograve; che vuoi: colori, immagini, testi... Geecom Cms dispone di 28 componenti, provali tutti!</p>', 'sfondo', 'immagini/slider/slide3.png', '', '', '', '$linkAreaRiservata', 'btn btn-primary leggi-tutto mt-3', 'Pannello di controllo', 0, '2018-01-01 08:00:00', '2018-01-01 08:00:00');";

    //creazione pagina chi siamo
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_contenuti VALUES(NULL,0,'italiano','pagina','0','0','si','pubblicato','scadente','immagineATuttaLarghezza.php','si','','Chi siamo','Chi siamo','si','','','chi-siamo','','','','si',0,'immagini/slider/slide1.png','','','Geecom','$data','$data','$data','$data');";
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`,`idElemento`,`posizione`, `testo`,`idSezione`,`classeSezione`,`altreOpzioni`) VALUES
(NULL, 14, 3, 'contenuto', 0, 1, '<p>Questa &egrave; la tua pagina chi siamo, dovrai modificarla con la tua storia, nel frattempo ti raccontiamo la nostra :)</p>\r\n<p>Geecom &egrave; nato a fine 2012 da un\'idea di Andrea Pastore, che voleva creare una piattaforma leggera ed essenziale. Nel tempo si &egrave; arricchito con tantissime funzionalit&agrave;, ha integrato componenti sempre pi&ugrave; comuni come slider, gallerie e tanto altro, che non devono essere quindi scaricati esternamente.</p>\r\n<p>L\'idea alla base di Geecom &egrave; di fornire tutto quello che serve per fare un sito, e di concentrare gli sforzi su un singolo componente che offre la stessa funzionalit&agrave;: ad esempio non sono ammessi altri slider, ma se lo slider di Geecom pu&ograve; essere migliorato con qualche funzionalit&agrave; questa &egrave; benvenuta.</p>\r\n<p>Il vantaggio di questo approccio &egrave; che i componenti che ci sono non potranno mai causare problemi di stabilit&agrave; alla piattaforma, e sono ottimizzati al massimo per funzionare armonicamente con il resto del sistema.</p>', '', '','opzioneClasseColonne=col-12;');";
    
    //query per la pagina informativa sulla privacy
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_contenuti VALUES(NULL,0,'italiano','pagina','0','0','si','pubblicato','discreta','senzaColonneLaterali.php','si','','Informativa sulla privacy','Informativa sulla privacy','si','','','informativa-sulla-privacy','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`,`tipoElemento`, `idElemento`, `posizione`, `testo`, `idSezione`, `classeSezione`,`altreOpzioni`) VALUES(NULL, 14, 4,'contenuto', 0, 1, '<p>Questa &egrave; la tua informativa sulla privacy. Ti abbiamo preparato una
             pagina base che dovrai leggere ed eventualmente adattare al tuo caso specifico. Se non hai inserito script 
            aggiuntivi (esempio per scopi pubblicitari) ti baster&agrave; rimuovere queste righe introduttive, altrimenti 
            dovrai modificarla aggiungendo i vari script che hai aggiunto e spiegando il loro comportamento. Se vuoi 
            essere aiutato in questa operazione puoi utilizzare il nostro portfolio di generazione policy.</p>\r\n<p>
            <br />In questa pagina $nome $cognome, titolare del sito internet $titoloSito intende informare come avvengono il 
            trattamento e la protezione dei dati personali dei soggetti (utenti) che vi navigano all\'interno, con accesso 
            diretto dalla home page oppure da pagine interne.<br /><br /><b>Cookie tecnici</b><br />IL sito utilizza cookie tecnici 
            per stabilire se il \'utente &egrave; loggato oppure no. Le informazioni memorizzate servono esclusivamente ai fini del 
            di offrire una buona esperienza d\'uso per l\'utente e memorizzano, tra le altre cose, l\'indirizzo email, il nome e la data 
            dell\'ultimo accesso dell\'utente.<br /><br /><b>Modulo contatti</b><br />Nessuna informazione viene salvata nei database 
            del sito durante l\'invio di informazioni tramite i moduli di contatto. I dati vengono utilizzati esclusivamente per 
            recapitare l\'email al destinatario del sito.<br /><br /><b>Commenti</b><br />Il sito da la possibilit&agrave; di commentare 
            articoli, per farlo richiede di inserire, oltre al commento, nome ed email. Il dati inseriti tramite questa form vengono
            poi salvati nel database. Solo il nome e il commento vengono mostrati pubblicamente.<br />
            <br><br><b>Finalità del trattamento</b></br>
            I dati per le statistiche del sito vengono raccolti in forma anonima e sono volti unicamente a determinare quali sono gli 
            articoli o le categorie più interessanti, i banner più cliccati (e quando). I dati immessi nei moduli di contatto sono 
            raccolti al solo fine di poter rispondere alle mail o contattare gli autori dei commenti in caso di necessità.
            <br><br><b>I ruoli e le responsabilità in ambito privacy</b><br>
            I dati personali sono trattati da $nome $cognome, in qualità di titolare del trattamento. Informazioni più dettagliate sui nominativi dei responsabili del trattamento potranno essere richieste inviando una mail a $email.
            <br><br><b>Modalità del trattamento di dati</b><br>
            Il trattamento dei dati personali viene effettuato prevalentemente con software e supporti elettronici (DB, piattaforme di CRM, ecc.) per il tempo strettamente necessario a conseguire gli scopi per i quali i dati sono stati raccolti e, comunque, in conformità alla vigente normativa privacy.
            <br><br><b>Diritto all\'oblio</b><br>
            In base alla normativa vigente, l\'utente ha il diritto di richiedere il diritto all\'oblio, ossia la cancellazione di tutti i dati personali (inclusi gli eventuali commenti) in possesso di $titoloSito. Per esercitare tale diritto è necessario inviare una mail a $email</p>', '', '','opzioneClasseColonne=col-12;');";
    
    //creazione pagina contatti
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_contenuti VALUES(NULL,'0','italiano','pagina','0','0','si','pubblicato','scadente','immagineATuttaLarghezza.php','si','','Contatti','Contatti','si','','','contatti','','','','si',0,'immagini/altro/contatti.png','','','Geecom','$data','$data','$data','$data');";
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`,`idElemento`, `posizione`) VALUES
(NULL, 23, 5,'contenuto', 1, 2);";
    
    //creazione pagina blog
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_contenuti VALUES(NULL,0,'italiano','pagina','0','0','si','pubblicato','scadente','senzaColonneLaterali.php','no','','Blog','Blog','si','','','blog','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`,`tipoElemento`, `idElemento`,`posizione`, `testo`,`idSezione`,`classeSezione`) VALUES
(NULL, 39, 6,'contenuto', 0, 1, '', '', '');";

    // creo il portfolio della home
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geec_portfolio` (`id`, `nome`, `spazioOccupato`, `descrizione`, `etichettaAltriElementi`, `linkPagina`, `filtrabile`,  `senzaBordi`,`classeElementi`,`mostraNomiElementi`,`aspetto`,`aspectRatio`) VALUES
(NULL, 'Metti in mostra i tuoi lavori!','col-12','Il componente Portfolio puoi mostrare le tue ultime creazioni o i lavori più importanti. Scegli quanto spazio far occupare a ciascuno fra sei diverse possibili combinazioni','Altri elementi','','no','','portfolio col-sm-6 col-md-4','no','classico','aspect-ratio-1-1');";
     
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_contenuti VALUES
(NULL,1,'italiano','elementoPortfolio','1','0','si','pubblicato','','temaElementoPortfolioGalleriaImmagini-8-4.php','si','','Opera 1','Opera 1','si','','','opera-1','','','<p>Questo &egrave; un esempio di come appare una pagina portfolio. Dall\'area amministrativa puoi personalizzare la descrizione e aggiungere altre immagini.</p>','no',0,'immagini/portfolio/portfolio1.png','','','Geecom','$data','$data','$data','$data'),
(NULL,1,'italiano','elementoPortfolio','2','0','si','pubblicato','','temaElementoPortfolioGalleriaImmagini-8-4.php','si','','Opera 2','Opera 2','si','','','opera-2','','','<p>Questo &egrave; un esempio di come appare una pagina portfolio. Dall\'area amministrativa puoi personalizzare la descrizione e aggiungere altre immagini.</p>','no',0,'immagini/portfolio/portfolio2.png','','','Geecom','$data','$data','$data','$data'),
(NULL,1,'italiano','elementoPortfolio','3','0','si','pubblicato','','temaElementoPortfolioGalleriaImmagini-8-4.php','si','','Opera 3','Opera 3','si','','','opera-3','','','<p>Questo &egrave; un esempio di come appare una pagina portfolio. Dall\'area amministrativa puoi personalizzare la descrizione e aggiungere altre immagini.</p>','no',0,'immagini/portfolio/portfolio3.png','','','Geecom','$data','$data','$data','$data'),
(NULL,1,'italiano','elementoPortfolio','4','0','si','pubblicato','','temaElementoPortfolioGalleriaImmagini-8-4.php','si','','Opera 4','Opera 4','si','','','opera-4','','','<p>Questo &egrave; un esempio di come appare una pagina portfolio. Dall\'area amministrativa puoi personalizzare la descrizione e aggiungere altre immagini.</p>','no',0,'immagini/portfolio/portfolio4.png','','','Geecom','$data','$data','$data','$data'),
(NULL,1,'italiano','elementoPortfolio','5','0','si','pubblicato','','temaElementoPortfolioGalleriaImmagini-8-4.php','si','','Opera 5','Opera 5','si','','','opera-5','','','<p>Questo &egrave; un esempio di come appare una pagina portfolio. Dall\'area amministrativa puoi personalizzare la descrizione e aggiungere altre immagini.</p>','no',0,'immagini/portfolio/portfolio5.png','','','Geecom','$data','$data','$data','$data'),
(NULL,1,'italiano','elementoPortfolio','6','0','si','pubblicato','','temaElementoPortfolioGalleriaImmagini-8-4.php','si','','Opera 6','Opera 6','si','','','opera-6','','','<p>Questo &egrave; un esempio di come appare una pagina portfolio. Dall\'area amministrativa puoi personalizzare la descrizione e aggiungere altre immagini.</p>','no',0,'immagini/portfolio/portfolio6.png','','','Geecom','$data','$data','$data','$data')";
    
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geec_immagini` (`id`, `idContenuto`, `tipoImmagine`, `percorso`, `descrizione`, `posizione`) VALUES
(NULL, 7, 'immagineElementoPortfolio', 'immagini/portfolio/portfolio1.png', '', 0),
(NULL, 8, 'immagineElementoPortfolio', 'immagini/portfolio/portfolio2.png', '', 1),
(NULL, 9, 'immagineElementoPortfolio', 'immagini/portfolio/portfolio3.png', '', 1),
(NULL, 10, 'immagineElementoPortfolio', 'immagini/portfolio/portfolio4.png', '', 1),
(NULL, 11, 'immagineElementoPortfolio', 'immagini/portfolio/portfolio5.png', '', 1),
(NULL, 12, 'immagineElementoPortfolio', 'immagini/portfolio/portfolio6.png', '', 2);";
    
    //query creazione pagina manutenzione
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_contenuti VALUES(NULL,0,'italiano','pagina','0','0','si','pubblicato','discreta','templateVuoto.php','si','','Sito in manutenzione','Sito in manutenzione','si','','','sito-in-manutenzione','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`,`posizione`, `testo`,`script`,`idSezione`,`classeSezione`,`animazione`,`altreOpzioni`) VALUES
(NULL, 14, 13,'contenuto',0, 2, '<p style=\"text-align: center;\"><i class=\"fas fa-circle-notch fa-spin fa-2x mb-3 text-primary\"></i></p><h3 style=\"text-align: center;\">Sito in manutenzione</h3><p style=\"text-align: center;\">Passa a trovarci fra un po\'</p><p style=\"text-align: center;\"><a href=\"mailto:$email\">$email</a></p>', '', '', '','','opzioneClasseColonne=col-12;')";
        
    //query creazazione della form presente nella pagina contatti
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geec_form` VALUES (NULL,'Modulo contatti','col-12','Messaggio a video','$email','Email','Nuovo messaggio dal tuo sito $titoloSito','','',0,'no','','','si','index.php?alias=informativa-sulla-privacy','Invia email','Invia','fas-paper-plane','col-12','','','no','',0,'','','','','',0,'no')";
    
    //la tabella impostazioni aspetto viene inizializzata con i valori di base
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_impostazioni VALUES (NULL,'classico','no','nessuno','no','no','no','si','Genera singola mappa con tutti i contenuti','no','no',0,'','no',0,'','no','','','no','si','bg-primary','text-white','no','no','chiave','si','no',2,0,0,0,0,'$urlSito','$titoloSito','$titoloSito','','italiano','no','13','si','no','','','no','','','si',1080,'no',240,'no','no','col-xl-6')";

    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecB_leggeCookie` (`id`, `lingua`, `attivaBarraCookie`, `durataCookie`, `testoBarraCookie`, `headCodiciCookie`, `fineBodyCookie`, `testoPulsanteAccetto`, `testoPulsanteNonAccetto`, `testoPulsanteMaggioriInformazioni`, `mostraPulsanteNonAccetto`, `mostraPulsanteMaggioriInformazioni`, `paginaMaggioriInformazioni`) VALUES 
                                                                (NULL, 'italiano', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4),
                                                                (NULL, 'inglese', 'si', 90 ,'<p class=\"mb-3\">This website uses cookies to give you the best experience on our website. </p>', '', '', 'Accept', 'Refuse', 'More information', 'si', 'si',4),
                                                                (NULL, 'tedesco', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4),
                                                                (NULL, 'francese', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4),
                                                                (NULL, 'spagnolo', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4);";
    
    /*
     * Query per inserire gli elementi di base nel modulo contatti
     */
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geec_elementiForm` (`id`, `idForm`, `posizione`, `spazioOccupato`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) VALUES
(1, 1, 1, 'col-12', 'Nome', 'Nome', '', 'Nome', 'Testo', '', ''),
(2, 1, 2, 'col-12', 'Cognome', 'Cognome', '', 'Cognome', 'Testo', '', ''),
(3, 1, 3, 'col-12', 'Email', 'Email', '', 'Email', 'Testo', '', ''),
(4, 1, 4, 'col-12', 'testo', 'Testo del messaggio', '', 'Testo del messaggio', 'Area testo', '', '');";
    
    
    // query per Geecom Admin
    
    // query creazione tabella impostazioni di Geecom Admin
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_impostazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `attivaHttps` varchar(55) NOT NULL,
        `logo` VARCHAR( 255 ) NOT NULL ,
        `logoMobile` VARCHAR( 255 ) NOT NULL ,
        `dimensioneAreaLogin` VARCHAR( 255 ) NOT NULL ,
        `titoloAreaLogin` VARCHAR( 255 ) NOT NULL ,
        `testoAreaLogin` TEXT( 65000 ) NOT NULL ,
        `menuSceltaLingue` VARCHAR(55) NOT NULL,
        `attivaFortino` VARCHAR(55) NOT NULL,
        `parolaChiaveFortino` varchar(55) NOT NULL,
        `tipoRedirectLogin` VARCHAR( 255 ) NOT NULL ,
        `linkPersonalizzatoLogin` VARCHAR( 255 ) NOT NULL ,        
        `paginaLogin` INT(11) NOT NULL,
        `paginaLoginEn` INT(11) NOT NULL,
        `paginaRegistrazione` INT(11) NOT NULL,
        `paginaRegistrazioneEn` INT(11) NOT NULL,
        `homePage` INT(11) NOT NULL,
        `homePageEn` INT(11) NOT NULL,
        `mostraProfilo` VARCHAR(55) NOT NULL,
        `paginaProfilo` INT(11) NOT NULL,
        `paginaProfiloEn` INT(11) NOT NULL,
        `paginaRecuperoPassword` INT(11) NOT NULL,
        `paginaRecuperoPasswordEn` INT(11) NOT NULL,
        `paginaNotifiche` INT(11) NOT NULL,
        `paginaNotificheEn` INT(11) NOT NULL,
        `urlPiattaforma` varchar(255) NOT NULL,
        `nomePiattaforma` varchar(255) NOT NULL,
        `descrizioneSito` varchar(255) NOT NULL,
        `consentiIndicizzazione` varchar(255) NOT NULL,
        `ottimizzazioneUrl` varchar(255) NOT NULL,
        `attivaCache` varchar(255) NOT NULL,
        `linguaSito` varchar(255) NOT NULL,
        `nomeMittente` VARCHAR (255) NOT NULL,
        `emailMittente` VARCHAR (255) NOT NULL,
        `utenteSmtp` VARCHAR (255) NOT NULL,
        `hostSmtp` VARCHAR (255) NOT NULL,
        `portaSmtp` SMALLINT (6) NOT NULL,
        `passwordSmtp` VARCHAR (255) NOT NULL,
        `disattivaAccessoUtenti` VARCHAR(55) NOT NULL,
        `messaggioAccessoDisattivato` VARCHAR(255) NOT NULL,
        `registrazioneUtenti` VARCHAR(255) NOT NULL,
        `gruppoDefault` INT(11) NOT NULL,
        `statoInizialeNuoviUtenti` VARCHAR(55) NOT NULL,
        `mailNotifiche` VARCHAR (255) NOT NULL ,
        `inviaNotificaMailNuovoUtente` VARCHAR (55) NOT NULL ,
        `inviaNotificaMailNuoveComunicazioni` VARCHAR(55) NOT NULL,
        `accessoFacebook` VARCHAR(255) NOT NULL,
        `accessoGoogle` VARCHAR(255) NOT NULL,
        `coloreBarraSuperiore` varchar(255) NOT NULL,
        `coloreTestoBarraSuperiore` varchar(255) NOT NULL,
        `attivaApi` VARCHAR(255) NOT NULL,
        `emailApi` VARCHAR(255) NOT NULL,
        `idAppFacebook` VARCHAR (255) NOT NULL ,
        `secretAppFacebook` VARCHAR (255) NOT NULL ,
        `filtraggioIP` VARCHAR( 55 ) NOT NULL ,
        `indirizziIPAmmessi` TEXT( 65000 ) NOT NULL ,
        `indirizziIPBannati` TEXT( 65000 ) NOT NULL ,
        `filtraggioIPAreaUtenti` VARCHAR( 55 ) NOT NULL ,
        `indirizziIPAmmessiAreaUtenti` TEXT( 65000 ) NOT NULL ,
        `indirizziIPBannatiAreaUtenti` TEXT( 65000 ) NOT NULL ,
        `attivaContabilita` VARCHAR( 55 ) NOT NULL ,
        `tipoContabilita` VARCHAR( 55 ) NOT NULL ,
        `percentualeIva` VARCHAR( 55 ) NOT NULL ,
        `intestazioneDocumentiFiscali` TEXT (1000),
        `gruppoClienti` INT ( 11 ) NOT NULL ,
        `gruppoFornitori` INT ( 11 ) NOT NULL ,
        `ottimizzaImmaginiCaricate` VARCHAR( 55 ) NOT NULL ,
        `altezzaImmagine` SMALLINT( 6 ) NOT NULL ,
        `generaThumbnail` VARCHAR( 55 ) NOT NULL ,
        `altezzaThumbnail` SMALLINT( 6 ) NOT NULL ,
        `comprimiCss` VARCHAR( 55 ) NOT NULL ,
        `comprimiJs` VARCHAR( 55 ) NOT NULL ,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
          
    //query per creare la tabella delle impostazioni delle lingue
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_impostazioniLingue` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `linguaPrincipale` VARCHAR(255) NOT NULL ,
        `impostazioniItaliano` VARCHAR(255) NOT NULL ,
        `menuItaliano` INT(11) NOT NULL ,
        `impostazioniInglese` VARCHAR(255) NOT NULL ,
        `menuInglese` INT(11) NOT NULL ,
        `impostazioniTedesco` VARCHAR(255) NOT NULL ,
        `menuTedesco` INT(11) NOT NULL ,        
        `impostazioniFrancese` VARCHAR(255) NOT NULL ,
        `menuFrancese` INT(11) NOT NULL ,
        `impostazioniSpagnolo` VARCHAR(255) NOT NULL ,
        `menuSpagnolo` INT(11) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella dei componenti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_componenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `componenteArticolo` VARCHAR( 255 ) NOT NULL ,
        `icona` VARCHAR( 255 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `paginaGestione` VARCHAR( 255 ) NOT NULL,
        `tabellaRiferimento` VARCHAR( 255 ) NOT NULL,
        `script` VARCHAR( 255 ) NOT NULL,
        `versione` VARCHAR( 255 ) DEFAULT '',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    // query per creare la tabella per comporre gli elementi del layout. Per elementi si intendono
    // il pannello laterale di destra, la barra superiore e il footer
    // ogni componente è ordinabile
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_composizioneElementi` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `idComponente` INT( 11 ) NOT NULL ,
        `idElemento` INT( 11 ) NOT NULL ,
        `pannello` VARCHAR( 255 ) NOT NULL ,
        `testo` VARCHAR( 255 ) NOT NULL ,
        `posizione` TINYINT( 11 ) NOT NULL ,
        `nomeDaMostrare` VARCHAR( 255 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";


    
    //query per creare la tabella della colonna laterale di sinistra che consente di capire quali componenti 
    //mostrare a lato e in che ordine
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_composizionePagine` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `idComponente` INT( 11 ) NOT NULL ,
        `idPagina` INT( 11 ) NOT NULL ,
        `tipoElemento` VARCHAR( 255 ) NOT NULL ,
        `idElemento` INT( 11 ) NOT NULL ,
        `posizione` TINYINT( 11 ) NOT NULL ,
        `testo` TEXT( 65000 ) ,
        `codiceGenerato` TEXT( 65000 ) ,
        `script` TEXT( 65000 ) ,
        `idSezione` VARCHAR( 255 ) DEFAULT '' ,
        `classeSezione` VARCHAR( 255 ) DEFAULT '' ,
        `aTuttaLarghezza` VARCHAR( 55 ) DEFAULT '' ,
        `margineSezione` VARCHAR( 255 ) DEFAULT '' ,
        `paddingSezione` VARCHAR( 255 ) DEFAULT '' ,
        `animazione` VARCHAR( 255 ) DEFAULT '' ,
        `coloreSfondo` VARCHAR( 255 ) DEFAULT '' ,
        `immagineSfondo` VARCHAR( 255 ) DEFAULT '' ,
        `videoSfondo` VARCHAR( 255 ) DEFAULT '' ,
        `altreOpzioni` TEXT( 65000 ),
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    // query per creare la tabella contenuti, che contiene pagine, gallerie e articoli ed
    // elementi portfolio. Gallerie ed elementi portfolio lasceranno alcuni campi vuoti
    // 
    // il campo posizione ad esempio è utilizzato solo dal portfolio
    // cosi come il campo tipoVisualizzazione è usato solo dalla galleria
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_contenuti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `contenutoRiferimento` INT( 11 ) NOT NULL,
        `linguaContenuto` VARCHAR( 55 ) NOT NULL ,
        `tipo` VARCHAR( 55 ) NOT NULL ,
        `privato` VARCHAR( 255 ) NOT NULL ,
        `posizione` INT( 11 ) NOT NULL,
        `categoria` INT( 11 ) NOT NULL,
        `mostraNellaHome` VARCHAR( 255 ) NOT NULL ,
        `stato` VARCHAR( 255 ) NOT NULL ,
        `punteggioSeo` VARCHAR( 255 ) NOT NULL ,
        `template` VARCHAR( 255 ) NOT NULL ,
        `attivaBreadcrumbs` VARCHAR( 255 ) NOT NULL ,
        `tipoVisualizzazione` VARCHAR( 255 ) NOT NULL ,
        `titolo` VARCHAR( 255 ) NOT NULL ,
        `mostraTitolo` VARCHAR( 255 ) NOT NULL ,
        `metaDescrizione` VARCHAR( 255 ) NOT NULL ,
        `descrizione` VARCHAR( 255 ) NOT NULL ,
        `alias` VARCHAR( 255 ) NOT NULL ,
        `cssGenerato` TEXT( 65000 ) NOT NULL ,
        `cssAggiuntivo` TEXT( 65000 ) NOT NULL ,
        `testo` TEXT( 65000 ) NOT NULL ,
        `abilitaCommenti` VARCHAR( 255 ) NOT NULL ,
        `numeroVisite` INT( 11 ) NOT NULL ,
        `foto` VARCHAR( 255 ) NOT NULL ,
        `miniaturaFoto` VARCHAR( 255 ) NOT NULL ,
        `etichettaImmagine` VARCHAR(255) NOT NULL, 
        `autore` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL ,
        `dataUltimaVisita` DATE NOT NULL ,
        `dataUltimaModifica` DATE NOT NULL ,
        `dataPubblicazione` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_visiteGiornaliere` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `numeroVisite` VARCHAR( 255 ) NOT NULL ,
        `dataCorrente` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
        
    /*
     * query creazione tabella per memorizzare le preferenze sui cookie
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_leggeCookie` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `lingua` VARCHAR( 55 ) NOT NULL,
        `attivaBarraCookie` VARCHAR( 55 ) NOT NULL,
        `durataCookie` SMALLINT( 6 ) NOT NULL,
        `testoBarraCookie` TEXT( 1000 ) NOT NULL,
        `headCodiciCookie` TEXT( 1000 ) NOT NULL,
        `fineBodyCookie` TEXT( 1000 ) NOT NULL,
        `testoPulsanteAccetto` VARCHAR( 255 ) NOT NULL,
        `testoPulsanteNonAccetto` VARCHAR( 255 ) NOT NULL,
        `testoPulsanteMaggioriInformazioni` VARCHAR( 255 ) NOT NULL,
        `mostraPulsanteNonAccetto` VARCHAR( 255 ) NOT NULL,
        `mostraPulsanteMaggioriInformazioni` VARCHAR( 255 ) NOT NULL,
        `paginaMaggioriInformazioni` INT(11) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella comunicazioni
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_comunicazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idUtente` INT( 11 ) NOT NULL ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `stato` VARCHAR( 255 ) NOT NULL ,
        `priorita` VARCHAR( 255 ) NOT NULL ,
        `template` VARCHAR( 255 ) NOT NULL ,
        `oggetto` VARCHAR( 255 ) NOT NULL ,
        `testo` TEXT( 65535 ) NOT NULL ,
        `autore` VARCHAR( 255 ) NOT NULL ,
        `inviaEmail` VARCHAR( 255 ) NOT NULL ,
        `inviaNotifica` VARCHAR( 255 ) NOT NULL ,
        `efficacia` VARCHAR( 255 ) NOT NULL ,
        `mailInviate` INT( 11 ) NOT NULL ,
        `mailNonInviate` INT( 11 ) NOT NULL ,
        `logInvio` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATETIME NOT NULL ,
        `dataInvio` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    // query per creare la tabella che memorizza i componenti della singola comunicazione (solo quando
    // si tratta di una comunicazione di tipo "comunicazione", che viene creata dagli amministratori
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecAd_composizioneComunicazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idComunicazione` INT( 11 ) NOT NULL,
        `idComponente` INT( 11 ) NOT NULL,
        `testo` TEXT( 65000 ) NOT NULL,
        `posizione` TINYINT( 4 ) NOT NULL ,
        `altreOpzioni` TEXT( 65000 ),
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";


    //query per creare la tabella risposteTicket
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_risposteTicket` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idTicket` INT( 11 ) NOT NULL ,
        `testo` TEXT( 65535 ) NOT NULL ,
        `autore` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella dei gruppi
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_gruppiDestinatari` (
            `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
            `idComunicazione` INT( 11 ) NOT NULL ,
            `idRisorsa` INT( 11 ) NOT NULL ,
            `idGruppoDestinatario` INT( 11 ) NOT NULL ,
            PRIMARY KEY ( `id` )
        )ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare i documenti fiscali: preventivi, fatture, riceveute e voci prima nota
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_documentiContabili` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `numeroDocumento` INT( 11 ) NOT NULL,
        `idUtente` INT( 11 ) NOT NULL,
        `tipo` VARCHAR (255) NOT NULL ,
        `entrataUscita` VARCHAR (55) NOT NULL ,
        `etichetta` VARCHAR (255) NOT NULL ,
        `numero` INT( 11 ) NOT NULL,
        `oggetto` VARCHAR (255) NOT NULL ,
        `testo` TEXT (65000) NOT NULL ,
        `imponibile` DOUBLE( 10,2 ) NOT NULL,
        `iva` DOUBLE( 10,2 ) NOT NULL,
        `totale` DOUBLE( 10,2 ) NOT NULL,
        `metodoPagamento` VARCHAR( 55 ) NOT NULL,
        `stato` VARCHAR( 55 ) NOT NULL,
        `giorniNecessari` SMALLINT( 6 ) NOT NULL,
        `giorniValidita` SMALLINT( 6 ) NOT NULL,
        `dataEmissione` DATE NOT NULL,
        `dataPagamento` DATE,
        `dataAccettazione` DATE,
        PRIMARY KEY (`id`)
        )ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
        
    /*
     * query creazione tabella per memorizzare le singole voci di fatture e ricevure
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_vociDocumentiContabili` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idDocumento` INT( 11 ) NOT NULL,
        `descrizione` VARCHAR (255) NOT NULL ,
        `quantita` SMALLINT(6) NOT NULL,
        `prezzo` DOUBLE(10,2) NOT NULL,
        `iva` TINYINT (4) NOT NULL,
        `totaleParziale` DOUBLE(10,2) NOT NULL,
        PRIMARY KEY (`id`)
        )ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare voci predefinite di fatture e ricevure
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_vociDocumentiContabiliPredefinite` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `descrizione` VARCHAR (255) NOT NULL ,
        `prezzo` DOUBLE(10,2) NOT NULL,
        `iva` TINYINT (4) NOT NULL,
        PRIMARY KEY (`id`)
        )ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
        
    /*
     * query creazione tabella per memorizzare le impostazioni del footer
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_footer` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `lingua` VARCHAR( 55 ) NOT NULL,
        `testo` TEXT( 65000 ) NOT NULL,
        `attivaFooterSuperiore` TEXT( 65000 ) NOT NULL,
        `numeroColonne` TEXT( 1000 ) NOT NULL,
        `colonna1` VARCHAR( 255 ) NOT NULL,
        `colonna2` VARCHAR( 255 ) NOT NULL,
        `colonna3` VARCHAR( 255 ) NOT NULL,
        `colonna4` VARCHAR( 255 ) NOT NULL,
        `titoloColonna1` VARCHAR( 255 ) NOT NULL,
        `titoloColonna2` VARCHAR( 255 ) NOT NULL,
        `titoloColonna3` VARCHAR( 255 ) NOT NULL,
        `titoloColonna4` VARCHAR( 255 ) NOT NULL,
        `coloreFooterInferiore` VARCHAR( 255 ) NOT NULL,
        `coloreFooterSuperiore` VARCHAR( 255 ) NOT NULL,
        `coloreTestiMenu` VARCHAR( 255 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query per la creazione delle query comuni
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_inclusioni` (
      `id` INT(11) NOT NULL AUTO_INCREMENT,
      `inizioHead` TEXT(65000) NOT NULL,
      `fineHead` TEXT(65000) NOT NULL,
      `inizioBody` TEXT(65000) NOT NULL,
      `fineBody` TEXT(65000) NOT NULL,
      `footer` TEXT(65000) NOT NULL,
    PRIMARY KEY ( `id` )
    ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    // query per creare la tabella delle etichette, utilizzata per le voci in contabilità nella prima nota e per gli utenti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_etichette` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    // query per creare la tabella moduliRegistrazione, che contiene sia pagine che gallerie
    // gallerie lascerà alcuni campi vuoti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_moduliRegistrazione` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR (255) NOT NULL ,
        `richiediNome` VARCHAR (255) NOT NULL ,
        `richiediCognome` VARCHAR (255) NOT NULL ,
        `richiediCitta` VARCHAR (255) NOT NULL ,
        `richiediOrganizzazione` VARCHAR (255) NOT NULL ,
        `richiediCodiceFiscale` VARCHAR (255) NOT NULL ,
        `richiediPartitaIva` VARCHAR (255) NOT NULL ,
        `richiediEmail` VARCHAR (255) NOT NULL ,
        `richiediTelefono` VARCHAR (255) NOT NULL ,
        `richiediPassword` VARCHAR (255) NOT NULL ,
        `richiediGruppo` VARCHAR (255) NOT NULL ,
        `gruppoObbligatorio` VARCHAR (255) NOT NULL ,
        `inviaMailConferma` VARCHAR (255) NOT NULL ,
        `inviaPasswordViaEmail` VARCHAR (255) NOT NULL ,
        `contenutoEmailRegistrazione` VARCHAR (255) NOT NULL ,
        `inviaNotificaNuovoUtente` VARCHAR (255) NOT NULL ,
        `mailNotificheNuoviUtenti` VARCHAR (255) NOT NULL ,
        PRIMARY KEY ( `id` )
        )ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella delle voci di menu
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_menu` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `formRicerca` VARCHAR( 55 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella delle voci di menu
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_vociMenu` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idMenu` INT( 11 ) NOT NULL,
        `idContenuto` INT( 11 ) NOT NULL,
        `vocePadre` INT( 11 ) NOT NULL,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `icona` VARCHAR( 255 ) NOT NULL ,
        `immagine` VARCHAR( 255 ) NOT NULL ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `link` VARCHAR( 255 ) NOT NULL,
        `posizione` INT( 11 ) NOT NULL,
        `gruppoSpecifico` INT( 11 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella risorse
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_risorse` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idUtente` INT( 11 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `password` VARCHAR( 255 ) NOT NULL ,
        `percorso` VARCHAR( 255 ) NOT NULL ,
        `descrizione` VARCHAR( 255 ) NOT NULL ,
        `immagine` VARCHAR( 255 ) NOT NULL ,
        `categoria` INT( 11 ) NOT NULL ,
        `accessibilita` VARCHAR( 55 ) NOT NULL ,
        `posizione` INT( 11 ) NOT NULL ,
        `numeroDownload` INT( 11 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare i moduli di contatto
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_cruscotti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `spazioOccupato` VARCHAR( 55 ) DEFAULT 'col-12' ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare gli elementi presenti in un cruscotto
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_elementiCruscotto` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `idCruscotto` INT(11) NOT NULL,
        `posizione` tinyINT(4) NOT NULL,
        `spazioOccupato` VARCHAR( 55 ) DEFAULT 'col-12' ,
        `nome` varchar(255) NOT NULL,
        `coloreSfondo` varchar(255) NOT NULL,
        `coloreTesti` varchar(255) NOT NULL,
        `classiAggiuntive` varchar(255) NOT NULL,
        `icona` varchar(255) NOT NULL,
        `stile` varchar(255) NOT NULL,
        `stilePulsanti` varchar(255) NOT NULL,
        `etichettaPulsante1` varchar(255) NOT NULL,
        `etichettaPulsante2` varchar(255) NOT NULL,
        `linkPulsante1` varchar(255) NOT NULL,
        `linkPulsante2` varchar(255) NOT NULL,
        `valoreMostrato` varchar(255) NOT NULL,
        `valoreDaMostrare` varchar(255) NOT NULL,
        `query` varchar(255) NOT NULL,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";

    // query per creare la tabella statistiche, che contiene sia pagine che gallerie
    // gallerie lascerà alcuni campi vuoti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_statistiche` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `numeroLogin` INT( 11 ) NOT NULL ,
        `loginOggi` INT( 11 ) NOT NULL ,
        `dataUltimoLogin` DATE NOT NULL ,
        `dataInstallazione` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella contenente i dati per gli input esterni
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE IF NOT EXISTS `geec_inputEsterni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `attivo` VARCHAR( 55 ) NOT NULL,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `tipoRichiesta` VARCHAR( 55 ) NOT NULL,
        `parametroIdentificativo` VARCHAR( 255 ) NOT NULL ,
        `valoreParametro` VARCHAR( 255 ) NOT NULL ,
        `azione` VARCHAR( 255 ) NOT NULL ,
        `linkDestinazione` VARCHAR( 255 ) NOT NULL ,
        `numeroChiamate` INT( 11 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    $data = date("Y-m-d H:i");
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_moduliRegistrazione VALUES
        (NULL,'Modulo registrazione 1','no','no','no','no','no','no','no','no','no','no','no','no','no','La tua registrazione è stata effettuata con successo<br>Grazie!','si','$email');";
        
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_componenti (`id`,`tipo`,`componenteArticolo`,`icona`,`nome`,`paginaGestione`,`tabellaRiferimento`,`script`) VALUES
        (NULL,'barraSuperiore','no','','Menu','','',''),
        (NULL,'barraSuperiore','no','','Menu scelta lingue','','',''),
        (NULL,'barraSuperiore','no','','Profili social','','',''),
        (NULL,'barraSuperiore','no','','Testo','','',''),
        (NULL,'barraSuperiore','no','','Modulo login','','',''),
        (NULL,'interno','no','','Articoli piu letti','','',''),
        (NULL,'interno','no','','Categorie','','',''),
        (NULL,'interno','no','','Tag','','',''),
        (NULL,'interno','no','','Form ricerca', '','',''),
        (NULL,'interno','no','','Banner laterale','','',''),
        (NULL,'interno','no','','Ultime risorse','','',''),
        (NULL,'interno','no','','Ultime gallerie','','',''),
        (NULL,'interno','no','','Ultimi articoli','','',''),
        (NULL,'interno','no','','HTML personalizzato','htmlPersonalizzato','',''),
        (NULL,'interno','no','','Categoria in evidenza','categoriaInEvidenza','',''),
        (NULL,'interno','no','','Menu laterale','menuLaterale','',''),
        (NULL,'interno','no','','Testo personalizzato','testoPersonalizzato','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_intestazione.svg','Intestazione','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_testo.svg','Testo','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_html.svg','HTML','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_immagine_a_tutta_larghezza.svg','Immagine','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_pulsante.svg','Pulsante','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_articolo_blog.svg','Articolo dal blog','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_prodotto_negozio.svg','Prodotto dal negozio','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_intestazione.svg','Intestazione','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_testo.svg','Testo','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_html.svg','Html','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_codice.svg','Includi codice', '','',''),
        (NULL,'componenteDinamico','si','../template/img/componenti/icon_immagine_a_tutta_larghezza.svg','Immagine','','',''),
        (NULL,'componenteDinamico','si','../template/img/componenti/icon_audio.svg','Audio','','',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_video.svg','Video', 'video','geec_video',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_form.svg','Form', 'form','geec_form',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_risorse.svg','Risorse','visualizzatoreRisorse','geec_visualizzatoriRisorse',''),
        (NULL,'componenteDinamicoNonConfigurabile','no','../template/img/componenti/icon_login.svg','Modulo login','','',''),
        (NULL,'componenteDinamicoNonConfigurabile','no','../template/img/componenti/icon_registrazione.svg','Modulo registrazione','','',''),
        (NULL,'componenteDinamicoNonConfigurabile','no','../template/img/componenti/icon_loginRegistrati.svg','Modulo login/registrati','','',''),
        (NULL,'componenteDinamicoNonConfigurabile','no','../template/img/componenti/icon_recupero_password.svg','Modulo recupera password','','',''),
        (NULL,'componenteDinamicoNonConfigurabile','no','../template/img/componenti/icon_notifiche.svg','Visualizzatore notifiche','','',''),
        (NULL,'componenteDinamicoNonConfigurabile','no','../template/img/componenti/icon_profilo.svg','Visualizzatore pagina profilo','','',''),
        (NULL,'componenteStrutturaPagina','no','../template/img/componenti/icon_sezione_2.svg','Sezione a due colonne','','geec_sezioniADueColonne',''),
        (NULL,'componenteStrutturaPagina','no','../template/img/componenti/icon_sezione_3.svg','Sezione a tre colonne','','geec_sezioniATreColonne',''),
        (NULL,'componenteStrutturaPagina','no','../template/img/componenti/icon_sezione_4.svg','Sezione a quattro colonne','','geec_sezioniAQuattroColonne',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_cruscotto.svg','Cruscotto','cruscotto','geec_cruscotti','');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_impostazioni` (`id`, `attivaHttps`, `logo`, `logoMobile`, `dimensioneAreaLogin`, `titoloAreaLogin`, `testoAreaLogin`, `menuSceltaLingue`, `attivaFortino`, `parolaChiaveFortino`, `tipoRedirectLogin` ,`linkPersonalizzatoLogin`, `paginaLogin`, `paginaLoginEn`, `paginaRegistrazione`, `paginaRegistrazioneEn`, `homePage`, `homePageEn`, `mostraProfilo`, `paginaProfilo`, `paginaProfiloEn`, `paginaRecuperoPassword`, `paginaRecuperoPasswordEn`, `paginaNotifiche`, `paginaNotificheEn`, `urlPiattaforma`, `nomePiattaforma`, `descrizioneSito`, `consentiIndicizzazione`, `ottimizzazioneUrl`, `attivaCache`, `linguaSito`, `nomeMittente`, `emailMittente`, `utenteSmtp`, `hostSmtp`, `portaSmtp`, `passwordSmtp`, `disattivaAccessoUtenti`, `messaggioAccessoDisattivato`, `registrazioneUtenti`, `gruppoDefault`, `statoInizialeNuoviUtenti`, `mailNotifiche`,`inviaNotificaMailNuovoUtente`, `inviaNotificaMailNuoveComunicazioni`, `accessoFacebook`, `accessoGoogle`,`coloreBarraSuperiore`,`coloreTestoBarraSuperiore`,`attivaApi`, `emailApi`, `idAppFacebook`, `secretAppFacebook`, `filtraggioIP`, `indirizziIPAmmessi`, `indirizziIPBannati`, `filtraggioIPAreaUtenti`, `indirizziIPAmmessiAreaUtenti`, `indirizziIPBannatiAreaUtenti`, `attivaContabilita`, `tipoContabilita`, `percentualeIva`, `intestazioneDocumentiFiscali`, `gruppoClienti`, `gruppoFornitori`,`ottimizzaImmaginiCaricate`,`altezzaImmagine`,`generaThumbnail`,`altezzaThumbnail`,`comprimiCss`,`comprimiJs`) 
                                                                VALUES (NULL, 'no', 'template/logo.svg', 'template/logo-mobile.svg', '', 'Accesso a Geecom Admin', '', 'no', 'no','', 'Home page di Geecom Admin', '', '1', '0', '2', '0', '3', '0', 'si','4', '0', '5', '0', '6', '0', '$urlSito/areariservata', 'Area riservata di $titoloSito', '', 'no', 'no','', 'italiano', '', '', '', '', 0, '', 'no', 'Accesso disattivato dall\'amministratore', 'no', '0', 'attivato','$email','no','si','no', 'no', 'bg-primary','navbar-dark','no', 'no', '','', '','', '', 'no', '', '', 'no', 'no', '0', '', '0', '0','si',1080,'no',240,'no','no')";

    // inizializzo la tabella impostazioniLingue
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_impostazioniLingue VALUES (NULL,'italiano', 'si','1','','0','','0','','0', '','0')";

    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_statistiche VALUES(NULL,0,0,'$data','$data');";
    
    //crea il menu principale
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_menu VALUES (NULL,'Menu principale','si')";

    //query per creare le voci di base (home e contatti) e le inserisce nel menu principale
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_vociMenu (`id`,`idMenu`,`nome`,`idContenuto`,`vocePadre`,`icona`,`immagine`,`tipo`,`link`,`posizione`,`gruppoSpecifico`) VALUES
        (NULL,1,'Home',2,0,'','','link','index.php?alias=home-page',1,0),
        (NULL,1,'Comunicazioni',0,0,'','','link','comunicazioni.php?tipo=comunicazione',2,0),
        (NULL,1,'Segnalazioni',0,0,'','','link','comunicazioni.php?tipo=segnalazione',3,0),
        (NULL,1,'Ticket',0,0,'','','link','comunicazioni.php?tipo=ticket',4,0);";
    
     //query per creare il footer. In Geecom viene visto come una sorta di contenuto
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_footer` VALUES (NULL, 'italiano', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','bg-dark','bg-primary','text-dark'),"
                                                                                            . "(NULL, 'inglese', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','bg-dark','bg-primary','text-dark'),"
                                                                                            . "(NULL, 'tedesco', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','bg-dark','bg-primary','text-dark'),"
                                                                                            . "(NULL, 'francese', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','bg-dark','bg-primary','text-dark'),"
                                                                                            . "(NULL, 'spagnolo', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','bg-dark','bg-primary','text-dark');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_leggeCookie` (`id`, `lingua`, `attivaBarraCookie`, `durataCookie`, `testoBarraCookie`, `headCodiciCookie`, `fineBodyCookie`, `testoPulsanteAccetto`, `testoPulsanteNonAccetto`, `testoPulsanteMaggioriInformazioni`, `mostraPulsanteNonAccetto`, `mostraPulsanteMaggioriInformazioni`, `paginaMaggioriInformazioni`) "
            . "VALUES (NULL, 'italiano', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4),"
            . "(NULL, 'inglese', 'si', 90 ,'<p class=\"mb-3\">This website uses cookies to give you the best experience on our website.</p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4),"
            . "(NULL, 'tedesco', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4),"
            . "(NULL, 'francese', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4),"
            . "(NULL, 'spagnolo', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4);";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_inclusioni` (`id`, `inizioHead`, `fineHead`, `inizioBody`, `fineBody`, `footer`) VALUES (NULL, '', '', '', '', '')";

    //creazione pagina login
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','no','0','0','si','pubblicato','','paginaDiServizio.php','si','','Login','no','','','login','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 34, 1, 'contenuto', 0, 1, NULL, NULL, NULL, '', '', '', '', NULL);";
    
    //creazione pagina registrazione
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','no','0','0','si','pubblicato','','paginaDiServizio.php','si','','Registrazione','no','','','registrazione','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 35, 2, 'contenuto', 0, 1, NULL, NULL, NULL, '', '', '', '', NULL);";
    
    //creazione pagina Home page
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','templateBase.php','si','','Home page','si','','','home-page','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `aTuttaLarghezza`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 26, 3, 'contenuto', 0, 1, 'Questa è la home page della tua area riservata! Personalizzala dal pannello amministrativo', NULL, NULL, '', 'si', '', '', '', 'opzioneClasseColonne=col-12;');";
    
    //creazione pagina profilo
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','templateBase.php','si','','Profilo','si','','','profilo','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 39, 4, 'contenuto', 0, 1, NULL, NULL, NULL, '', '', '', '', NULL);";
        
    //creazione pagina recupero password
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','no','0','0','si','pubblicato','','paginaDiServizio.php','si','','Recupera password','no','','','recupera-password','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 37, 5, 'contenuto', 0, 1, NULL, NULL, NULL, '', '', '', '', NULL);";
        
    //creazione pagina notifiche
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','templateBase.php','si','','Notifiche','no','','','notifiche','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 38, 6, 'contenuto', 0, 1, NULL, NULL, NULL, '', '', '', '', NULL);";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','templateBase.php','si','','Informtiva sulla privacy','no','','','informativa-sulla-privacy','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`,`tipoElemento`, `idElemento`, `posizione`, `testo`, `idSezione`, `classeSezione`,`altreOpzioni`) VALUES(NULL, 26, 7,'contenuto', 0, 1, '<p>Questa &egrave; la tua informativa sulla privacy. Ti abbiamo preparato una
             pagina base che dovrai leggere ed eventualmente adattare al tuo caso specifico. Se non hai inserito script 
            aggiuntivi (esempio per scopi pubblicitari) ti baster&agrave; rimuovere queste righe introduttive, altrimenti 
            dovrai modificarla aggiungendo i vari script che hai aggiunto e spiegando il loro comportamento. Se vuoi 
            essere aiutato in questa operazione puoi utilizzare il nostro portfolio di generazione policy.</p>\r\n<p>
            <br />In questa pagina $nome $cognome, titolare del sito internet $titoloSito intende informare come avvengono il 
            trattamento e la protezione dei dati personali dei soggetti (utenti) che vi navigano all\'interno, con accesso 
            diretto dalla home page oppure da pagine interne.<br /><br /><b>Cookie tecnici</b><br />IL sito utilizza cookie tecnici 
            per stabilire se il \'utente &egrave; loggato oppure no. Le informazioni memorizzate servono esclusivamente ai fini del 
            di offrire una buona esperienza d\'uso per l\'utente e memorizzano, tra le altre cose, l\'indirizzo email, il nome e la data 
            dell\'ultimo accesso dell\'utente.<br /><br /><b>Modulo contatti</b><br />Nessuna informazione viene salvata nei database 
            del sito durante l\'invio di informazioni tramite i moduli di contatto. I dati vengono utilizzati esclusivamente per 
            recapitare l\'email al destinatario del sito.<br /><br /><b>Commenti</b><br />Il sito da la possibilit&agrave; di commentare 
            articoli, per farlo richiede di inserire, oltre al commento, nome ed email. Il dati inseriti tramite questa form vengono
            poi salvati nel database. Solo il nome e il commento vengono mostrati pubblicamente.<br />
            <br><br><b>Finalità del trattamento</b></br>
            I dati per le statistiche del sito vengono raccolti in forma anonima e sono volti unicamente a determinare quali sono gli 
            articoli o le categorie più interessanti, i banner più cliccati (e quando). I dati immessi nei moduli di contatto sono 
            raccolti al solo fine di poter rispondere alle mail o contattare gli autori dei commenti in caso di necessità.
            <br><br><b>I ruoli e le responsabilità in ambito privacy</b><br>
            I dati personali sono trattati da $nome $cognome, in qualità di titolare del trattamento. Informazioni più dettagliate sui nominativi dei responsabili del trattamento potranno essere richieste inviando una mail a $email.
            <br><br><b>Modalità del trattamento di dati</b><br>
            Il trattamento dei dati personali viene effettuato prevalentemente con software e supporti elettronici (DB, piattaforme di CRM, ecc.) per il tempo strettamente necessario a conseguire gli scopi per i quali i dati sono stati raccolti e, comunque, in conformità alla vigente normativa privacy.
            <br><br><b>Diritto all\'oblio</b><br>
            In base alla normativa vigente, l\'utente ha il diritto di richiedere il diritto all\'oblio, ossia la cancellazione di tutti i dati personali (inclusi gli eventuali commenti) in possesso di $titoloSito. Per esercitare tale diritto è necessario inviare una mail a $email</p>', '', '','opzioneClasseColonne=col-12;');";
    
    //creazione riga per contenere le visite giornaliere, va inizializzata con la data dell'installazione
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_visiteGiornaliere` (`id`, `numeroVisite`, `dataCorrente`) VALUES (NULL, '0', '$data');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_etichette (`id`, `nome`, `tipo`, `dataCreazione`) VALUES(NULL,'Affitto','contabilita','$data'),(NULL,'Bollette','contabilita','$data'),(NULL,'Imposte e tasse','contabilita','$data'),(NULL,'Bonifico','metodoPagamento','$data'),(NULL,'Contanti','metodoPagamento','$data'),(NULL,'Paypal','metodoPagamento','$data'),(NULL,'Stripe','metodoPagamento','$data');";

    // query relative al componente ecommerce
        //query per creare la tabella dei prodotti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecEc_prodotti` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `codiceProdotto` VARCHAR(255) NOT NULL,
        `idFornitore` int(11) NOT NULL,
        `lingua` VARCHAR(55) NOT NULL,
        `prodottoRiferimento` int(11) NOT NULL,
        `prodottoPadre` int(11) NOT NULL,
        `ean` VARCHAR(55) NOT NULL,
        `nome` VARCHAR(255) NOT NULL,
        `alias` VARCHAR(255) NOT NULL,
        `immagine` VARCHAR(255) NOT NULL,
        `template` VARCHAR(255) NOT NULL,
        `pubblicato` VARCHAR(255) NOT NULL,
        `usaVariazioni` VARCHAR(55) NOT NULL,
        `categoria` int(11) NOT NULL,
        `disponibilita` mediumint(9) NOT NULL,
        `prodottoInesauribile` VARCHAR (55) NOT NULL,
        `prezzo` DOUBLE(8,2) NOT NULL,
        `prezzoOfferta` DOUBLE(8,2) NOT NULL,
        `iva` TINYINT(4) NOT NULL,
        `prezzoAcquisto` DOUBLE(8,2) NOT NULL,
        `prezzoUnitario` DOUBLE(8,2) NOT NULL,
        `unita` VARCHAR(255) NOT NULL,
        `minimoAcquisto` SMALLINT(6) NOT NULL,
        `metaDescrizione` text NOT NULL,
        `descrizione` text NOT NULL,
        `testoDettagli` text NOT NULL,
        `marca` VARCHAR(255) NOT NULL,
        `modello` VARCHAR(255) NOT NULL,
        `formato` VARCHAR(255) NOT NULL,
        `materiale` VARCHAR(255) NOT NULL,
        `capacità` VARCHAR(255) NOT NULL,
        `colore` VARCHAR(255) NOT NULL,
        `larghezza` mediumint(9) NOT NULL,
        `altezza` mediumint(9) NOT NULL,
        `profondità` mediumint(9) NOT NULL,
        `peso` DOUBLE(8,2) NOT NULL,
        `pesoVolumetrico` DOUBLE(8,2) NOT NULL,
        `acquistoOpzioneObbligatorio` VARCHAR(255) DEFAULT 'no',
        `tipoProdotto` VARCHAR(255) NOT NULL,
        `numeroVisite` int(11) NOT NULL,
        `numeroVendite` int(11) NOT NULL,
        `abilitaCommenti` VARCHAR(255) NOT NULL,
        `dataInserimento` date NOT NULL,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella delle opzioni di acquisto
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_attributiProdotto` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idProdotto` INT( 11 ) NOT NULL,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `valori` VARCHAR( 255 ) NOT NULL ,
        `costi` VARCHAR( 255 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
     //query per creare la tabella delle variazioni di prodotto
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_variazioniProdotto` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `codiceProdotto` VARCHAR( 255 ) NOT NULL ,
        `idProdotto` INT( 11 ) NOT NULL,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `costo` DOUBLE( 8,2 ) NOT NULL ,
        `quantita` MEDIUMINT NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //query per creare la tabella delle opzioni di acquisto
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_opzioniAcquisto` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `alias` VARCHAR( 255 ) NOT NULL ,
        `immagine` VARCHAR( 255 ) NOT NULL ,
        `pubblicato` VARCHAR( 255 ) NOT NULL ,
        `categoria` INT( 11 ) NOT NULL ,
        `prezzo` DOUBLE(8,2) NOT NULL,
        `descrizione` TEXT( 65000 ) NOT NULL,
        `dataInserimento` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella degli ordini
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_ordini` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idCliente` INT( 11 ) NOT NULL,
        `idCarrello` INT( 11 ) NOT NULL,
        `codiceSconto` VARCHAR (255) NOT NULL,
        `stato` VARCHAR(255) NOT NULL,
        `idTransazione` VARCHAR(255) NOT NULL,
        `destinatario` VARCHAR(255) NOT NULL,
        `indirizzoSpedizione` VARCHAR(255) NOT NULL ,
        `citta` VARCHAR(255) NOT NULL ,
        `capSpedizione` VARCHAR(255) NOT NULL ,
        `codiceTracciamento` VARCHAR(255) NOT NULL,
        `email` VARCHAR(255) NOT NULL,
        `telefono` VARCHAR(255) NOT NULL,
        `tipoSpedizione` VARCHAR(255) NOT NULL,
        `tipoPagamento` VARCHAR(255) NOT NULL,
        `codiceFiscale` VARCHAR(255) NOT NULL,
        `partitaIva` VARCHAR(255) NOT NULL,
        `tipoRicevuta` VARCHAR(255) NOT NULL,
        `importoTotaleOrdine` DOUBLE(8,2) NOT NULL ,
        `dataOrdine` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella degli ordini
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_abbonamenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idCliente` INT( 11 ) NOT NULL,
        `idProdotto` INT( 11 ) NOT NULL,
        `attributo` VARCHAR(255) NOT NULL,
        `stato` VARCHAR(255) NOT NULL,
        `ultimaTransazione` VARCHAR(255) NOT NULL,
        `destinatario` VARCHAR(255) NOT NULL,
        `indirizzoSpedizione` VARCHAR(255) NOT NULL ,
        `citta` VARCHAR(255) NOT NULL ,
        `capSpedizione` VARCHAR(255) NOT NULL ,
        `email` VARCHAR(255) NOT NULL,
        `telefono` VARCHAR(255) NOT NULL,
        `tipoSpedizione` VARCHAR(255) NOT NULL,
        `tipoPagamento` VARCHAR(255) NOT NULL,
        `tipoRicevuta` VARCHAR(255) NOT NULL,
        `importoTotaleOrdine` DOUBLE(8,2) NOT NULL ,
        `dataUltimoRinnovo` DATETIME NOT NULL ,
        `dataScadenza` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //imposta il valore iniziale dell'id a 1000
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "ALTER TABLE `geecEc_ordini` AUTO_INCREMENT=1000;";

    //query per creare la tabella dei carrelli, dove vengono memorizzati i dati
    //mentre l'utente sta effettuando l'acquisto. Al momento del pagamento i prodotti
    //nel carrello verranno messi in una tabella ordine
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_carrelli` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idCliente` INT( 11 ) NOT NULL,
        `idSpedizione` INT( 11 ) NOT NULL,
        `importoProdotti` DOUBLE (8,2) NOT NULL ,
        `ivaProdotti` DOUBLE (8,2) NOT NULL ,
        `importoSpedizione` DOUBLE (8,2) NOT NULL ,
        `buonoSconto` VARCHAR (255) NOT NULL ,
        `valoreBuonoSconto` DOUBLE (8,2) NOT NULL ,
        `importoTotale` DOUBLE (8,2) NOT NULL ,
        `nome` VARCHAR(255) NOT NULL ,
        `cognome` VARCHAR(255) NOT NULL ,
        `nazione` VARCHAR(255) NOT NULL ,
        `citta` VARCHAR(255) NOT NULL ,
        `indirizzo` VARCHAR(255) NOT NULL ,
        `capSpedizione` VARCHAR(255) NOT NULL ,
        `email` VARCHAR(255) NOT NULL,
        `telefono` VARCHAR(255) NOT NULL,
        `codiceFiscale` VARCHAR(255) NOT NULL,
        `partitaIva` VARCHAR(255) NOT NULL,
        `dataCreazione` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella dei coupon
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_buoniSconto` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR(255) NOT NULL,
        `codice` VARCHAR(255) NOT NULL,
        `tipo` VARCHAR(255) NOT NULL,
        `ammontareSconto` DOUBLE(9,2) NOT NULL,
        `prodottiInteressati` VARCHAR(255) NOT NULL,
        `prodotto` INT(11) NOT NULL,
        `categoria` INT(11) NOT NULL,
        `spesaMinima` DOUBLE(8,2) NOT NULL,
        `limitePerPersona` INT(11) NOT NULL,
        `buoniRimanenti` INT(11) NOT NULL,
        `dataCreazione` DATE NOT NULL,
        `dataScadenza` DATE NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //query per creare la tabella dei metodi di spedizione
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_metodiSpedizione` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR(255) NOT NULL ,
        `disponibile` VARCHAR(255) NOT NULL ,
        `categoria` VARCHAR(255) NOT NULL ,
        `descrizione` VARCHAR(255) NOT NULL ,
        `giorniNecessari` SMALLINT (6) NOT NULL,
        `giorniInCuiSiSpedisce` VARCHAR(255) NOT NULL ,
        `orarioLimite` TIME NOT NULL ,
        `costo` DOUBLE(9,2) NOT NULL ,
        `costoZoneDisagiate` DOUBLE(9,2) NOT NULL ,
        `importoMinimoCarrello` DOUBLE(9,2) NOT NULL ,
        `areaGeografica` INT(11) NOT NULL,
        `dataCreazione` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //query per modificare la tabella dei metodi di spedizione
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_fascePrezzoSpedizione` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idSpedizione` INT( 11 ) NOT NULL,
        `pesoMinimo` SMALLINT( 6 ) NOT NULL,
        `pesoMassimo` SMALLINT( 6 ) NOT NULL,
        `costo` DOUBLE(9,2) NOT NULL ,
        `costoZoneDisagiate` DOUBLE(9,2) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //query per creare la tabella delle zone disagiate per i metodi di spedizione
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_zoneDisagiate` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR(255) NOT NULL ,
        `capInizio` VARCHAR (255) NOT NULL ,
        `capFine` VARCHAR (255) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
     //query per creare la tabella delle aree geografiche per i metodi di spedizione
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_areeGeografiche` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR(255) NOT NULL ,
        `nazioni` TEXT (2500) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //query per creare la tabella dei prodotti ordinati, ovvero dei singoli prodotti che sono stati acquistati
    //in un ordine
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecEc_prodottiOrdinati` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `tipo` VARCHAR (255) NOT NULL,
        `idCarrello` INT( 11 ) NOT NULL,
        `idProdotto` INT( 11 ) NOT NULL,
        `idVariazione` INT NOT NULL,
        `quantita` MEDIUMINT NOT NULL,
        `nomeProdotto` VARCHAR (255) NOT NULL,
        `attributo` VARCHAR (255) NOT NULL,
        `prezzoUnitario` DOUBLE(8,2)  NOT NULL ,
        `ivaProdottoUnitario` DOUBLE(8,2)  NOT NULL ,
        `importoTotale` DOUBLE(8,2) NOT NULL ,
        `prezzoUnitarioOpzione` DOUBLE(8,2) NOT NULL ,
        `importoTotaleOpzione` DOUBLE(8,2) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella delle impostazioni base
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_impostazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `abilitaRitiroInSede` VARCHAR(255) NOT NULL ,
        `abilitaSpedizioneGratuita` VARCHAR(255) NOT NULL ,
        `importoMinimo` INT(9) NOT NULL ,
        `nascondiDivSpedizione` VARCHAR(255) NOT NULL ,
        `linkCondizioniAcquisto` VARCHAR(255) NOT NULL ,
        `posizioneBarraLaterale` VARCHAR(255) NOT NULL ,
        `bloccaAcquisti` VARCHAR(255) NOT NULL ,
        `mailOrdini` VARCHAR(255) NOT NULL ,
        `registrazioneObbligatoria` VARCHAR(255) NOT NULL ,
        `richiediPassword` VARCHAR(55) NOT NULL ,
        `attivaRaccomandazioneProdotti` VARCHAR(55) NOT NULL ,
        `numeroProdottiRaccomandatiDaMostrare` INT(11) NOT NULL ,
        `mostraSelettoreQuantita` VARCHAR(55) NOT NULL ,
        `mostraPezziRimanenti` VARCHAR(55) NOT NULL ,
        `mostraEanPaginaProdotto` VARCHAR(55) NOT NULL ,
        `attivaAreeGeografiche` VARCHAR(55) NOT NULL ,
        `nazioniDaVisualizzare` VARCHAR(55) NOT NULL ,
        `mostraCategorie` VARCHAR(255) NOT NULL ,
        `categoriePerRiga` SMALLINT(4) NOT NULL ,
        `aspettoProdottiOfferta` VARCHAR(255) NOT NULL,
        `prodottiInOffertaPerRiga` SMALLINT(4) NOT NULL,
        `messaggioPulsanteCarrelloPaginaProdotti` VARCHAR(500) NOT NULL,
        `mostraTempoNecessarioConsegna` VARCHAR(55) NOT NULL,
        `fraseTempoNecessarioConsegna` VARCHAR(500) NOT NULL,
        `aggiungiIvaProdotti` VARCHAR(55) NOT NULL,
        `valorePredefinitoIva` INT( 11 ) NOT NULL,
        `mostraIvaPrezziNegozio` VARCHAR(55) NOT NULL,
        `mostraIvaPrezziCarrello` VARCHAR(55) NOT NULL,
        `documentoFiscale` VARCHAR(55) NOT NULL,
        `prefissoDocumentoFiscale` VARCHAR(55) NOT NULL,
        `mostraQuantitaNelRiepilogo` VARCHAR(55) NOT NULL,
        `paginaAcquistoNonEffettuato` INT( 11 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella delle impostazioni della prima riga di prodotti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_righeProdotti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR(255) NOT NULL,
        `spazioOccupato` VARCHAR(55) DEFAULT 'col-12',
        `numeroProdotti` INT(11) NOT NULL DEFAULT 1,
        `dimensioneDivSingoloProdotto` VARCHAR(55) NOT NULL DEFAULT 'col-md-4',
        `tipoVisualizzazione` VARCHAR(55) NOT NULL DEFAULT 'tradizionale',
        `tipoProdotti` VARCHAR(55) NOT NULL DEFAULT '',
        `aspetto` VARCHAR(55) NOT NULL DEFAULT 'altezzaControllata',
        `lingua` VARCHAR(55) NOT NULL DEFAULT 'altezzaControllata',
        `etichettaPulsanteAltriProdotti` VARCHAR(255) NOT NULL DEFAULT '',
        `linkPulsanteAltriProdotti` VARCHAR(255) NOT NULL DEFAULT '',
        `mostraTitoloComponente` VARCHAR(255) NOT NULL DEFAULT '',
        `mostraPrezzo` VARCHAR(555) NOT NULL DEFAULT 'si',
        `escludiProdottiEsauriti` VARCHAR(555) NOT NULL DEFAULT 'si',
        `categoria` INT(11) NOT NULL DEFAULT 0,
        `categorieIndicate` VARCHAR( 255 ) NOT NULL DEFAULT '',
        `escludiCategoria` INT(11) NOT NULL DEFAULT 0,
        `marca` VARCHAR(255) NOT NULL DEFAULT '',
        `escludiMarca` VARCHAR(255) NOT NULL DEFAULT '',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella delle impostazioni base
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_impostazioniPagamenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nomeEstrattoConto` VARCHAR(255) NOT NULL,
        `attivaPagamentoConsegna` VARCHAR(255) NOT NULL,
        `dettagliPagamentoConsegna` VARCHAR(255) NOT NULL,
        `costoPagamentoConsegna` VARCHAR(255) NOT NULL,
        `attivaPaypal` VARCHAR(55) NOT NULL,
        `attivaPaypalCartaDiCredito` VARCHAR(55) NOT NULL,
        `attivaPagamento3Rate` VARCHAR(55) NOT NULL,
        `importoMinimoPagamento3Rate` DOUBLE(8,2) NOT NULL,
        `sandboxPaypal` VARCHAR(55) NOT NULL,
        `clientIdPaypal` VARCHAR(255) NOT NULL,
        `secretPaypal` VARCHAR(255) NOT NULL,
        `attivaStripe` VARCHAR(255) NOT NULL,
        `idAccountStripe` VARCHAR(255) NOT NULL,
        `chiavePubblicaStripe` VARCHAR(255) NOT NULL,
        `chiaveSegretaStripe` VARCHAR(255) NOT NULL,
        `attivaSatispay` VARCHAR(255) NOT NULL,
        `idAccountSatispay` VARCHAR(255) NOT NULL,
        `chiavePubblicaSatispay` VARCHAR(255) NOT NULL,
        `chiaveSegretaSatispay` VARCHAR(255) NOT NULL,
        `attivaContoCorrente` VARCHAR(255) NOT NULL,
        `dettagliContoCorrente` VARCHAR(255) NOT NULL,
        `attivaPrepagata` VARCHAR(255) NOT NULL,
        `dettagliPrepagata` VARCHAR(255) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecEc_transazioni`( 
        `id` int(30) NOT NULL AUTO_INCREMENT, 
        `idOrdineRiferimento` int(30) NOT NULL, 
        `txn_id` VARCHAR(50) NOT NULL, 
        `payment_status` VARCHAR(50) NOT NULL, 
        `payer_email` VARCHAR(100) NOT NULL, 
        `mc_gross` VARCHAR(10) NOT NULL, 
        `payment_date` VARCHAR(100) NOT NULL,
        PRIMARY KEY (`id`), UNIQUE KEY `txn_id` (`txn_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;";

    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecEc_impostazioniPaginaCarrello`( 
        `id` int(30) NOT NULL AUTO_INCREMENT, 
        `testoInAlto` TEXT(65000) NOT NULL, 
        `testoADestra` TEXT(65000) NOT NULL, 
        `testoInBasso` TEXT(65000) NOT NULL, 
        PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //inizializzo la tabella impostazioni
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecEc_impostazioni VALUES (NULL,'no','no',0,'','','destra','no','','no','no','no','0','si','no','no','no','','no',1,'altezzaControllata',3,'','no','Ricevilo entro __data__ se ordini entro le 24:00','no','0','','','nessuno','','si',0);";

    //inizializzo la tabella impostazioni
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecEc_impostazioniPaginaCarrello VALUES (NULL,'','','');";

    //creo la pagima "i miei ordini" per Geecom Admin
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','ordini.php','si','','I miei ordini','no','','','ordini','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    
    //creo la pagima "dettagli ordine" per Geecom Admin
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','dettagliOrdine.php','si','','Dettagli ordine','no','','','dettagli-ordine','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    
     //creo la pagima "i miei abbonamenti" per Geecom Admin
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','abbonamenti.php','si','','I miei abbonamenti','no','','','abbonamenti','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    
    //creo la pagima "dettagli abbonamento" per Geecom Admin
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','dettagliOrdine.php','si','','Dettagli abbonamento','no','','','dettagli-abbonamento','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    
    // aggiungo le voci di menu per Geecom Admin
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_vociMenu (`id`,`idMenu`,`nome`,`idContenuto`,`vocePadre`,`icona`,`immagine`,`tipo`,`link`,`posizione`,`gruppoSpecifico`) VALUES
            (NULL,1,'I miei ordini',2,0,'','','link','index.php?alias=ordini',4,0),
            (NULL,1,'I miei abbonamenti',2,0,'','','link','index.php?alias=abbonamenti',5,0);";

    //inizializzo la tabella impostazioni pagamenti
    $queryDiConfigurazione[count($queryDiConfigurazione)]  = "INSERT INTO geecEc_impostazioniPagamenti VALUES (NULL,'','no','no',0,'no','no','no',0,'no','','','no','','','','no','','','','no','','no','');";

    //crea il componente ecommerce
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_componenti VALUES (NULL,'esterno','no','../template/img/componenti/icon_ecommerce.svg','Ecommerce','ecommerce','','','Geecom e-commerce 4.0','si','no')";

    //crea il componente Visualizzatore riga prodotti
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_componenti VALUES (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_prodotti_negozio.svg','Prodotti dal negozio','prodottiDalNegozio','geecEc_righeProdotti','','','no','no')";
    
    //crea i componenti per il pannello laterale 
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecB_componenti (`id`,`tipo`,`componenteArticolo`,`icona`,`nome`,`paginaGestione`,`tabellaRiferimento`,`script`,`versione`) 
                                                                                                    VALUES (NULL,'pannelloLaterale','no','','Categorie ecommerce','','','',''),
                                                                                                           (NULL,'pannelloLaterale','no','','Prodotti più venduti','','','',''),
                                                                                                           (NULL,'pannelloLaterale','no','','Ultimi prodotti inseriti','','','',''),
                                                                                                           (NULL,'pannelloLaterale','no','','Elenco marche prodotti','','','','')";
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <title>Installazione di Geecom CMS</title>
        <?php
            include "../amministrazione/include/cssBaseAreaAmministrativa.php";
        ?>
    </head>
    <body class="bg-primary">
        <main role="main" class="d-flex align-items-center mt-0">
            <div id="installazione" class="container">
                <div class="row">
                    <div class="col-sm-8 col-md-6 mx-auto">
                        <div class="card box-shadow-lite mb-4">
                            <div class="row">
                                <div class="col-8 col-lg-6 mx-auto">
                                    <img class="img-fluid logo mb-4" src="../template/img/geecom.svg" />
                                </div>
                                <div class="col-12">
                                    <p>Installazione di Geecom <?php echo $infoGeecom["nomeProdotto"] ?>.</p>       
                                    
                                    <?php 
                                        if(!isset($_SESSION["altriProdotti"])) { //se la sessione non è stata settata non ci sono altri prodotti geecom
                                            //esegue in blocco le query di configurazione
                                            $geecomDb->eseguiInsiemeDiQuery($queryTabelleComuni);
                                            echo"<div class=\"alert alert-success\">Creazione tabelle base di Geecom completata</div>";
                                        }
                                        else { // se sono presenti altri prodotti deve essere solo aggiornata la cartella prodotti
                                            $queryCreazioneAdmin = "UPDATE geec_prodotti SET versione = '{$infoGeecom["versione"]}', percorso = '$cartellaAmministrazione' WHERE nome LIKE 'Admin'";
                                            $geecomDb->eseguiQueryScrittura($queryCreazioneAdmin);
                                            echo"<div class=\"alert alert-success\">Tabella Geecom aggiornata</div>";
                                        }

                                        //esegue in blocco le query che creano le tabelle dle database
                                        $geecomDb->eseguiInsiemeDiQuery($queryCreazioniTabelle);
                                        echo"<div class=\"alert alert-success\">Creazione tabelle di Geecom CMS completata</div>";

                                        //esegue in blocco le query di configurazione
                                        $geecomDb->eseguiInsiemeDiQuery($queryDiConfigurazione);
                                        
                                        $inclusioniGlobale = $geecomDb->leggiSingolaRiga("geecB_inclusioni",1);
    
                                        // modifico la tabella gruppi aggiungendo la percentuale di sconto
                                        $geecomDb->eseguiQueryScrittura("ALTER TABLE `geec_gruppi` ADD `percentualeSconto` TINYINT(4) NOT NULL DEFAULT '0' AFTER `descrizione`;");

                                        // aggiungo nelle inclusioni lo script dell'ecommerce 
                                        $geecomDb->eseguiQueryScrittura("UPDATE geecB_inclusioni SET fineBody = '{$inclusioniGlobale["fineBody"]} <script src=\"js/ecommerce/ecommerce.js\"></script>'");

                                        echo"<div class=\"alert alert-success\">Configurazione eseguita</div>";

                                        /***  eseguo ora una serie di query che devono essere eseguite dopo il blocco sopra ***/

                                        // creo una categoria ecommerce
                                        $queryCategoria = "INSERT INTO `geec_categorie` (`id`, `categoriaMadre`, `categoriaRiferimento`, `tipo`, `lingua`, `nome`, `alias`, `titoloPagina`, `metaDescrizione`, `cssGenerato`, `cssAggiuntivo`, `foto`, `punteggioSeo`, `tipoVisualizzazione`, `numeroArticoliPerPagina`, `posizione`, `ordinamento`, `dataCreazione`) 
                                                            VALUES (NULL, '0', '0', 'ecommerce', 'italiano', 'Categoria di prova', 'categoria-di-prova', '', '', '', '', '', 'scadente', 'classico', '12', '1', 'Data di pubblicazione, dal più nuovo', '$data'); ";
                                        $idCategoria    = $geecomDb->eseguiQueryCreazione($queryCategoria);

                                        // creo tre prodotto di esempio
                                        $queryInserimentoProdotti = "INSERT INTO `geecEc_prodotti` (`id`, `codiceProdotto`, `idFornitore`, `lingua`, `prodottoRiferimento`, `prodottoPadre`, `ean`, `nome`, `alias`, `immagine`, `template`, `pubblicato`, `usaVariazioni`, `categoria`, `disponibilita`, `prodottoInesauribile`, `prezzo`, `prezzoOfferta`, `iva`, `prezzoAcquisto`, `prezzoUnitario`, `unita`, `minimoAcquisto`, `metaDescrizione`, `descrizione`, `testoDettagli`, `marca`, `modello`, `formato`, `materiale`, `capacità`, `colore`, `larghezza`, `altezza`, `profondità`, `peso`, `pesoVolumetrico`, `acquistoOpzioneObbligatorio`, `tipoProdotto`, `numeroVisite`, `numeroVendite`, `abilitaCommenti`, `dataInserimento`) 
                                                                                                        VALUES (NULL, '','0', 'italiano', '0', '0', '', 'Prodotto di prova 1', 'prodotto-di-prova-1', 'immagini/ecommerce/prodotto-di-prova1.png', 'templateBaseProdotto.php', 'si', 'no','$idCategoria', '1', 'no', '10', '0', '0', '5', '0', '', '1','','<p>Questo &egrave; un prodotto di prova, puoi eliminarlo o modificarlo per trasformarlo nel prodotto che ti serve. Grazie per aver installato il componente e-commerce!</p>', '', '', '', '', '', '0', '', '0', '0', '0', '0', '0','no', 'fisico', '0', '0', 'no', '$data'),
                                                                                                           (NULL, '', '0','italiano', '0', '0', '', 'Prodotto di prova 2', 'prodotto-di-prova-2', 'immagini/ecommerce/prodotto-di-prova2.png', 'templateBaseProdotto.php', 'si', 'no','$idCategoria', '1', 'no', '10', '0', '0', '5', '0', '', '1','','<p>Questo &egrave; un prodotto di prova, puoi eliminarlo o modificarlo per trasformarlo nel prodotto che ti serve. Grazie per aver installato il componente e-commerce!</p>', '', '', '', '', '', '0', '', '0', '0', '0', '0', '0','no', 'fisico', '0', '0', 'no', '$data'),
                                                                                                           (NULL, '', '0','italiano', '0', '0', '', 'Prodotto di prova 3', 'prodotto-di-prova-3', 'immagini/ecommerce/prodotto-di-prova3.png', 'templateBaseProdotto.php', 'si', 'no','$idCategoria', '1', 'no', '10', '0', '0', '5', '0', '', '1','','<p>Questo &egrave; un prodotto di prova, puoi eliminarlo o modificarlo per trasformarlo nel prodotto che ti serve. Grazie per aver installato il componente e-commerce!</p>', '', '', '', '', '', '0', '', '0', '0', '0', '0', '0','no', 'fisico', '0', '0', 'no', '$data')";
                                        $geecomDb->eseguiQueryScrittura($queryInserimentoProdotti);

                                        // creo una visualizzatore prodotto
                                        $queryAggiornamentoRigheProdotto = "INSERT INTO `geecEc_righeProdotti` (`id`, `nome`, `spazioOccupato`, `numeroProdotti`, `dimensioneDivSingoloProdotto`, `tipoProdotti`, `aspetto`, `lingua`, `etichettaPulsanteAltriProdotti`, `linkPulsanteAltriProdotti`, `mostraTitoloComponente`, `mostraPrezzo`, `categoria`, `categorieIndicate`, `escludiCategoria`,`marca`,`escludiMarca`) 
                                                                                         VALUES (NULL, 'Visualizzatore 1', 'col-12', '3', 'col-md-4', 'casuali', 'altezzaControllata',  'italiano', '', '', 'no', 'si', '$idCategoria', '', '0','','')";
                                        $geecomDb->eseguiQueryScrittura($queryAggiornamentoRigheProdotto);

                                        // recupero i dati  del componente Prodotti dal negozio
                                        $datiComponenteEcommerce = $geecomDb->leggiSingolaRiga("geecB_componenti","Prodotti dal negozio","nome");

                                        // infine creo la pagina Negozio in Geecom CMS e aggiungo il componente
                                        $queryCreazionePagina = "INSERT INTO geecB_contenuti VALUES(NULL,'0','italiano','pagina','0','0','si','pubblicato','','senzaColonneLaterali.php','si','','Negozio','Negozio','si','','','negozio','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
                                        $idPaginaNegozio = $geecomDb->eseguiQueryCreazione($queryCreazionePagina);
                                        $queryAggiuntaComponenteEcommerce = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`,`posizione`, `testo`, `script`,`idSezione`,`classeSezione`) VALUES
                        (NULL, {$datiComponenteEcommerce["id"]}, $idPaginaNegozio, 'contenuto',1, 1, '','','','');";
                                        $geecomDb->eseguiQueryScrittura($queryAggiuntaComponenteEcommerce);

                                        // inserisco la posizione del negozio
                                        $queryAggiuntaVoceMenuNegozio = "INSERT INTO geecB_vociMenu (`id`,`idMenu`,`idContenuto`,`vocePadre`,`mostraNomiColonne`,`testoAssociato`,`nome`,`icona`,`immagine`,`tipo`,`link`,`posizione`) VALUES
                                                                            (NULL,1,$idPaginaNegozio,0,'','','Negozio','','','link','index.php?alias=negozio',2),
                                                                            (NULL,1,0,0,'','','Carrello','fas fa-shopping-cart','','linkCarrello','carrello.php',5)";
                                        $geecomDb->eseguiQueryScrittura($queryAggiuntaVoceMenuNegozio);

                                        // inserisco le spedizioni di base
                                        $queryCreazioneSpedizioni = "INSERT INTO `geecEc_metodiSpedizione` (`id`, `nome`, `disponibile`, `categoria`, `descrizione`, `giorniNecessari`, `giorniInCuiSiSpedisce`, `orarioLimite`, `costo`, `costoZoneDisagiate`, `importoMinimoCarrello`, `areaGeografica`, `dataCreazione`) 
                                                                            VALUES (NULL, 'Spedizione gratuita', 'no', '', 'Spedizione gratuita', 2, 'Lunedi - Venerdi', '00:00', '0', '0', '0', '0', '2021-10-18'),
                                                                                   (NULL, 'Corriere espresso', 'si', '', 'Spedizione in 2 - 3 giorni lavorativi', 2, 'Lunedi - Venerdi', '00:00', '7', '7', '0', '0', '2021-10-18');";
                                        $geecomDb->eseguiQueryScrittura($queryCreazioneSpedizioni);
                                        
                                        // attivo le API di Geecom Admin
                                        $queryAggiornamentoApiAdmin = "UPDATE geecAd_impostazioni SET attivaApi='si' WHERE id=1";
                                        $geecomDb->eseguiQueryScrittura($queryAggiornamentoApiAdmin);
                                        
                                        $dataOggi = date("Y-m-d");
                                        $queryCreazioneAdmin = "INSERT INTO geec_utenti VALUES(NULL,'$email','$password','super admin','$nome','$cognome','','','', '', '', '', '', NULL, '', '', '', '', '', '','', '', '','attivato', 'si', '', '$dataOggi', '$dataOggi')";
                                        $geecomDb->eseguiQueryScrittura($queryCreazioneAdmin);
                                        echo"<div class=\"alert alert-success\" role=\"alert\">Utente amministratore creato</div>";

                                        rename(realpath(str_replace("installazione","amministrazione",__DIR__)), str_replace("installazione","$cartellaAmministrazione",__DIR__));
                                        echo"<div class=\"alert alert-success\" role=\"alert\">Installazione terminata!</div>";

                                        echo"<div class=\"alert alert-warning\">Salva il link di accesso alla tua area amministrativa: <b>$urlSito/$cartellaAmministrazione</b></div>";
                                    ?>

                                    <a href="<?php echo $linkAreaRiservata ?>" class="btn btn-success btn-block">Vai all'area amministrativa</a>

                                    <div class="card m-0 bg-light p-3 mt-3">
                                        <strong class="text-center text-primary">Sei nuovo di Geecom?</strong>
                                        <hr>
                                        
                                        <div class="row">
                                            <div class="col-md-6 text-center">
                                                <a href="https://www.geecom.org/?alias=impara-ad-utilizzare-geecom"> 
                                                    <i class="fas fa-rocket d-block fa-2x text-primary mb-2"></i>
                                                    Comincia da qui
                                                </a>
                                            </div>
                                            
                                            <div class="col-md-6 text-center">
                                                <a href="https://www.geecom.org/scaricaFile.php?id=2"> 
                                                    <i class="fas fa-book d-block fa-2x text-primary mb-2"></i>
                                                    Scarica il manuale gratuito</a>
                                            </div>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- /container -->
        </main>
        
        <?php
            include "../$cartellaAmministrazione/include/footer.php";
        ?>
        
        <!-- Optional JavaScript -->
	<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
	<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.1/js/bootstrap.min.js" integrity="sha384-smHYKdLADwkXOn1EmN1qk/HfnUcbVRZyYmZ4qpPea6sjB/pTJ0euyQp0Mk8ck+5T" crossorigin="anonymous"></script>  
	
	<!-- Tooltips e Popover -->
	<script>
            $(function () {
              $('[data-toggle="tooltip"]').tooltip()
            }) 
	</script>
	  
  </body>
</html>
